/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.authentication.standard;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.SslMode;
import org.mariadb.r2dbc.authentication.standard.Sha256PasswordPluginFlow;
import org.mariadb.r2dbc.message.AuthMoreData;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.client.AuthMoreRawPacket;
import org.mariadb.r2dbc.message.client.ClearPasswordPacket;
import org.mariadb.r2dbc.message.client.Sha256PasswordPacket;
import org.mariadb.r2dbc.message.client.Sha2PublicKeyRequestPacket;
import org.mariadb.r2dbc.message.server.Sequencer;

public final class CachingSha2PasswordFlow
extends Sha256PasswordPluginFlow {
    public static final String TYPE = "caching_sha2_password";
    private State state = State.INIT;
    private PublicKey publicKey;

    public static byte[] sha256encryptPassword(CharSequence password, byte[] seed) {
        if (password == null) {
            return new byte[0];
        }
        byte[] truncatedSeed = new byte[seed.length - 1];
        System.arraycopy(seed, 0, truncatedSeed, 0, seed.length - 1);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] bytePwd = password.toString().getBytes(StandardCharsets.UTF_8);
            byte[] stage1 = messageDigest.digest(bytePwd);
            messageDigest.reset();
            byte[] stage2 = messageDigest.digest(stage1);
            messageDigest.reset();
            messageDigest.update(stage2);
            messageDigest.update(truncatedSeed);
            byte[] digest = messageDigest.digest();
            byte[] returnBytes = new byte[digest.length];
            for (int i = 0; i < digest.length; ++i) {
                returnBytes[i] = (byte)(stage1[i] ^ digest[i]);
            }
            return returnBytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not use SHA-256, failing", e);
        }
    }

    @Override
    public CachingSha2PasswordFlow create() {
        return new CachingSha2PasswordFlow();
    }

    @Override
    public String type() {
        return TYPE;
    }

    public void setStateFastAuth() {
        this.state = State.FAST_AUTH_RESULT;
    }

    @Override
    public ClientMessage next(MariadbConnectionConfiguration configuration, byte[] seed, Sequencer sequencer, AuthMoreData authMoreData) throws R2dbcException {
        if (authMoreData == null) {
            this.state = State.INIT;
        }
        CharSequence password = configuration.getPassword();
        switch (this.state.ordinal()) {
            case 0: {
                byte[] fastCryptedPwd = CachingSha2PasswordFlow.sha256encryptPassword(password, seed);
                this.state = State.FAST_AUTH_RESULT;
                return new AuthMoreRawPacket(sequencer, fastCryptedPwd);
            }
            case 1: {
                ByteBuf buf = authMoreData.getBuf();
                if (buf.getByte(buf.readerIndex()) == 1) {
                    buf.readByte();
                }
                byte fastAuthResult = buf.readByte();
                switch (fastAuthResult) {
                    case 3: {
                        return null;
                    }
                    case 4: {
                        if (configuration.getSslConfig().getSslMode() != SslMode.DISABLE) {
                            this.state = State.SEND_AUTH;
                            return new ClearPasswordPacket(authMoreData.getSequencer(), password);
                        }
                        if (configuration.getCachingRsaPublicKey() != null && !configuration.getCachingRsaPublicKey().isEmpty()) {
                            this.publicKey = configuration.getCachingRsaPublicKey().contains("BEGIN PUBLIC KEY") ? CachingSha2PasswordFlow.generatePublicKey(configuration.getCachingRsaPublicKey().getBytes()) : CachingSha2PasswordFlow.readPublicKeyFromFile(configuration.getCachingRsaPublicKey());
                            this.state = State.SEND_AUTH;
                            return new Sha256PasswordPacket(authMoreData.getSequencer(), configuration.getPassword(), seed, this.publicKey);
                        }
                        if (!configuration.allowPublicKeyRetrieval()) {
                            throw new R2dbcNonTransientResourceException("RSA public key is not available client side (option serverRsaPublicKeyFile) and option 'allowPublicKeyRetrieval' is disabled. Either set one or the other", "S1009");
                        }
                        this.state = State.REQUEST_SERVER_KEY;
                        return new Sha2PublicKeyRequestPacket(authMoreData.getSequencer());
                    }
                }
                throw new R2dbcNonTransientResourceException("Protocol exchange error. Expect login success or RSA login request message", "S1009");
            }
            case 2: {
                this.publicKey = CachingSha2PasswordFlow.readPublicKey(authMoreData.getBuf());
                this.state = State.SEND_AUTH;
                return new Sha256PasswordPacket(authMoreData.getSequencer(), configuration.getPassword(), seed, this.publicKey);
            }
        }
        throw new R2dbcNonTransientResourceException("Wrong state", "S1009");
    }

    public static enum State {
        INIT,
        FAST_AUTH_RESULT,
        REQUEST_SERVER_KEY,
        SEND_AUTH;

    }
}

