/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.Assert;

public final class MariadbRowMetadata
implements RowMetadata {
    private final ColumnDefinitionPacket[] metadataList;
    private volatile Collection<String> columnNames;
    private Map<String, Integer> mapper = null;

    public MariadbRowMetadata(ColumnDefinitionPacket[] metadataList) {
        this.metadataList = metadataList;
    }

    public ColumnDefinitionPacket getColumnMetadata(int index) {
        if (index < 0 || index >= this.metadataList.length) {
            throw new IndexOutOfBoundsException(String.format("Column index %d is not in permit range[0,%s]", index, this.metadataList.length - 1));
        }
        return this.metadataList[index];
    }

    public ColumnDefinitionPacket getColumnMetadata(String name) {
        return this.metadataList[this.getIndex(name)];
    }

    public List<ColumnDefinitionPacket> getColumnMetadatas() {
        return Arrays.asList(this.metadataList);
    }

    private Collection<String> getColumnNames(ColumnDefinitionPacket[] columnMetadatas) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnDefinitionPacket columnMetadata : columnMetadatas) {
            columnNames.add(columnMetadata.getName());
        }
        return Collections.unmodifiableCollection(columnNames);
    }

    public String toString() {
        if (this.columnNames == null) {
            this.columnNames = this.getColumnNames(this.metadataList);
        }
        return "MariadbRowMetadata{columnNames=" + this.columnNames + "}";
    }

    public boolean contains(String columnName) {
        if (this.columnNames == null) {
            this.columnNames = this.getColumnNames(this.metadataList);
        }
        return this.columnNames.stream().anyMatch(columnName::equalsIgnoreCase);
    }

    public int size() {
        return this.metadataList.length;
    }

    ColumnDefinitionPacket get(int index) {
        return this.metadataList[index];
    }

    int getIndex(String name) throws NoSuchElementException {
        Integer ind;
        Assert.requireNonNull(name, "name must not be null");
        if (this.mapper == null) {
            HashMap<String, Integer> tmpmapper = new HashMap<String, Integer>();
            for (int i = 0; i < this.metadataList.length; ++i) {
                ColumnDefinitionPacket ci = this.metadataList[i];
                String columnAlias = ci.getName();
                if (columnAlias == null || columnAlias.isEmpty()) {
                    String columnName = ci.getColumn();
                    if (columnName == null || columnName.isEmpty()) continue;
                    columnName = columnName.toLowerCase(Locale.ROOT);
                    tmpmapper.putIfAbsent(columnName, i);
                    continue;
                }
                tmpmapper.putIfAbsent(columnAlias.toLowerCase(Locale.ROOT), i);
            }
            this.mapper = tmpmapper;
        }
        if ((ind = this.mapper.get(name.toLowerCase(Locale.ROOT))) == null) {
            throw new NoSuchElementException(String.format("Column name '%s' does not exist in column names %s", name, Collections.unmodifiableCollection(this.mapper.keySet())));
        }
        return ind;
    }
}

