/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.authentication.standard;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.authentication.AuthenticationPlugin;
import org.mariadb.r2dbc.message.AuthMoreData;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.client.ParsecAuthPacket;
import org.mariadb.r2dbc.message.client.RequestExtSaltPacket;
import org.mariadb.r2dbc.message.server.Sequencer;

public class ParsecPasswordPlugin
implements AuthenticationPlugin {
    private static byte[] pkcs8Ed25519header = new byte[]{48, 46, 2, 1, 0, 48, 5, 6, 3, 43, 101, 112, 4, 34, 4, 32};

    @Override
    public ParsecPasswordPlugin create() {
        return new ParsecPasswordPlugin();
    }

    @Override
    public String type() {
        return "parsec";
    }

    @Override
    public ClientMessage next(MariadbConnectionConfiguration configuration, byte[] seed, Sequencer sequencer, AuthMoreData authMoreData) {
        Signature ed25519Signature;
        KeyFactory ed25519KeyFactory;
        if (authMoreData == null) {
            return new RequestExtSaltPacket(sequencer);
        }
        byte firstByte = 0;
        int iterations = 100;
        ByteBuf buf = authMoreData.getBuf();
        if (buf.readableBytes() > 2) {
            firstByte = buf.readByte();
            iterations = buf.readByte();
        }
        if (firstByte != 80 || iterations > 3) {
            throw new R2dbcNonTransientResourceException("Wrong parsec authentication format", "S1009");
        }
        byte[] salt = new byte[buf.readableBytes()];
        buf.readBytes(salt);
        char[] password = configuration.getPassword() == null ? new char[]{} : configuration.getPassword().toString().toCharArray();
        try {
            ed25519KeyFactory = KeyFactory.getInstance("Ed25519");
            ed25519Signature = Signature.getInstance("Ed25519");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                ed25519KeyFactory = KeyFactory.getInstance("Ed25519", "BC");
                ed25519Signature = Signature.getInstance("Ed25519", "BC");
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException ee) {
                throw new R2dbcNonTransientResourceException("Parsec authentication not available. Either use Java 15+ or add BouncyCastle dependency", (Throwable)e);
            }
        }
        try {
            PBEKeySpec spec = new PBEKeySpec(password, salt, 1024 << iterations, 256);
            SecretKey key = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512").generateSecret(spec);
            byte[] derivedKey = key.getEncoded();
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(this.combineArray(pkcs8Ed25519header, derivedKey));
            PrivateKey privateKey = ed25519KeyFactory.generatePrivate(keySpec);
            byte[] clientScramble = new byte[32];
            SecureRandom.getInstanceStrong().nextBytes(clientScramble);
            ed25519Signature.initSign(privateKey);
            ed25519Signature.update(this.combineArray(seed, clientScramble));
            byte[] signature = ed25519Signature.sign();
            return new ParsecAuthPacket(sequencer, clientScramble, signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new R2dbcNonTransientResourceException("Error during parsec authentication", (Throwable)e);
        }
    }

    private byte[] combineArray(byte[] arr1, byte[] arr2) {
        byte[] combined = new byte[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, combined, 0, arr1.length);
        System.arraycopy(arr2, 0, combined, arr1.length, arr2.length);
        return combined;
    }
}

