/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.authentication.addon.gssapi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Reader;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.plugin.authentication.addon.gssapi.GssapiAuth;

public class StandardGssapiAuthentication
implements GssapiAuth {
    @Override
    public void authenticate(Writer out, Reader in, String servicePrincipalName, String mechanisms) throws SQLException, IOException {
        block15: {
            if ("".equals(servicePrincipalName)) {
                throw new SQLException("No principal name defined on server. Please set server variable \"gssapi-principal-name\" or set option \"servicePrincipalName\"", "28000");
            }
            if (System.getProperty("java.security.auth.login.config") == null) {
                File jaasConfFile;
                try {
                    jaasConfFile = File.createTempFile("jaas.conf", null);
                    try (PrintStream bos = new PrintStream(new FileOutputStream(jaasConfFile));){
                        bos.print("Krb5ConnectorContext {\ncom.sun.security.auth.module.Krb5LoginModule required useTicketCache=true debug=true renewTGT=true doNotPrompt=true; };");
                    }
                    jaasConfFile.deleteOnExit();
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                System.setProperty("java.security.auth.login.config", jaasConfFile.getCanonicalPath());
            }
            try {
                LoginContext loginContext = new LoginContext("Krb5ConnectorContext");
                loginContext.login();
                Subject mySubject = loginContext.getSubject();
                if (!mySubject.getPrincipals().isEmpty()) {
                    try {
                        PrivilegedExceptionAction<Void> action = () -> {
                            try {
                                Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
                                GSSManager manager = GSSManager.getInstance();
                                GSSName peerName = manager.createName(servicePrincipalName, GSSName.NT_USER_NAME);
                                GSSContext context = manager.createContext(peerName, krb5Mechanism, null, 0);
                                context.requestMutualAuth(true);
                                byte[] inToken = new byte[]{};
                                while (true) {
                                    byte[] outToken;
                                    if ((outToken = context.initSecContext(inToken, 0, inToken.length)) != null) {
                                        out.writeBytes(outToken);
                                        out.flush();
                                    }
                                    if (!context.isEstablished()) {
                                        ReadableByteBuf buf = in.readReusablePacket();
                                        inToken = new byte[buf.readableBytes()];
                                        buf.readBytes(inToken);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (GSSException le) {
                                throw new SQLException("GSS-API authentication exception", "28000", 1045, le);
                            }
                            return null;
                        };
                        Subject.doAs(mySubject, action);
                        break block15;
                    }
                    catch (PrivilegedActionException exception) {
                        throw new SQLException("GSS-API authentication exception", "28000", 1045, exception);
                    }
                }
                throw new SQLException("GSS-API authentication exception : no credential cache not found.", "28000", 1045);
            }
            catch (LoginException le) {
                throw new SQLException("GSS-API authentication exception", "28000", 1045, le);
            }
        }
    }
}

