/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import org.mariadb.jdbc.CallParameter;
import org.mariadb.jdbc.CallableParameterMetaData;
import org.mariadb.jdbc.CallableProcedureStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.com.send.parameters.NullParameter;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.util.dao.CloneableCallableStatement;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionFactory;

public class MariaDbProcedureStatement
extends CallableProcedureStatement
implements CloneableCallableStatement {
    private SelectResultSet outputResultSet = null;

    public MariaDbProcedureStatement(String query, MariaDbConnection connection, String procedureName, String database, int resultSetType, int resultSetConcurrency, ExceptionFactory exceptionFactory) throws SQLException {
        super(connection, query, resultSetType, resultSetConcurrency, exceptionFactory);
        this.parameterMetadata = new CallableParameterMetaData(connection, database, procedureName, false);
        this.setParamsAccordingToSetArguments();
        this.setParametersVariables();
    }

    private void setParamsAccordingToSetArguments() {
        this.params = new ArrayList(this.parameterCount);
        for (int index = 0; index < this.parameterCount; ++index) {
            this.params.add(new CallParameter());
        }
    }

    private void setInputOutputParameterMap() {
        if (this.outputParameterMapper == null) {
            this.outputParameterMapper = new int[this.params.size()];
            int currentOutputMapper = 1;
            for (int index = 0; index < this.params.size(); ++index) {
                this.outputParameterMapper[index] = ((CallParameter)this.params.get(index)).isOutput() ? currentOutputMapper++ : -1;
            }
        }
    }

    @Override
    protected SelectResultSet getOutputResult() throws SQLException {
        if (this.outputResultSet == null) {
            if (this.fetchSize != 0) {
                this.results.loadFully(false, this.protocol);
                this.outputResultSet = this.results.getCallableResultSet();
                if (this.outputResultSet != null) {
                    this.outputResultSet.next();
                    return this.outputResultSet;
                }
            }
            throw new SQLException("No output result.");
        }
        return this.outputResultSet;
    }

    @Override
    public MariaDbProcedureStatement clone(MariaDbConnection connection) throws CloneNotSupportedException {
        MariaDbProcedureStatement clone = (MariaDbProcedureStatement)super.clone(connection);
        clone.outputResultSet = null;
        return clone;
    }

    private void retrieveOutputResult() throws SQLException {
        this.outputResultSet = this.results.getCallableResultSet();
        if (this.outputResultSet != null) {
            this.outputResultSet.next();
        }
    }

    @Override
    public void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        ((CallParameter)this.params.get(parameterIndex - 1)).setInput(true);
        super.setParameter(parameterIndex, holder);
    }

    @Override
    public boolean execute() throws SQLException {
        this.connection.lock.lock();
        try {
            this.validAllParameters();
            super.executeInternal(this.fetchSize);
            this.retrieveOutputResult();
            boolean bl = this.results != null && this.results.getResultSet() != null;
            return bl;
        }
        finally {
            this.connection.lock.unlock();
        }
    }

    private void validAllParameters() throws SQLException {
        this.setInputOutputParameterMap();
        for (int index = 0; index < this.params.size(); ++index) {
            if (((CallParameter)this.params.get(index)).isInput()) continue;
            super.setParameter(index + 1, new NullParameter());
        }
        this.validParameters();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (!this.hasInOutParameters) {
            return super.executeBatch();
        }
        throw new SQLException("executeBatch not permit for procedure with output parameter");
    }
}

