/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.keycloak.models.oid4vci.CredentialScopeModel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KeyAttestationsRequired {
    @JsonProperty(value="key_storage")
    private List<String> keyStorage;
    @JsonProperty(value="user_authentication")
    private List<String> userAuthentication;

    public static KeyAttestationsRequired parse(CredentialScopeModel credentialScope) {
        KeyAttestationsRequired keyAttestationsRequired = null;
        if (credentialScope.isKeyAttestationRequired()) {
            keyAttestationsRequired = new KeyAttestationsRequired();
            keyAttestationsRequired.setKeyStorage(credentialScope.getRequiredKeyAttestationKeyStorage());
            keyAttestationsRequired.setUserAuthentication(credentialScope.getRequiredKeyAttestationUserAuthentication());
        }
        return keyAttestationsRequired;
    }

    public List<String> getKeyStorage() {
        return this.keyStorage;
    }

    public KeyAttestationsRequired setKeyStorage(List<String> keyStorage) {
        this.keyStorage = keyStorage;
        return this;
    }

    public List<String> getUserAuthentication() {
        return this.userAuthentication;
    }

    public KeyAttestationsRequired setUserAuthentication(List<String> userAuthentication) {
        this.userAuthentication = userAuthentication;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyAttestationsRequired that = (KeyAttestationsRequired)o;
        return Objects.equals(this.keyStorage, that.keyStorage) && Objects.equals(this.userAuthentication, that.userAuthentication);
    }

    public int hashCode() {
        return Objects.hash(this.keyStorage, this.userAuthentication);
    }
}

