/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cache;

import java.util.List;
import java.util.Map;
import org.keycloak.cache.AlternativeLookupProvider;
import org.keycloak.cache.ComputedKey;
import org.keycloak.cache.LocalCache;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.IdentityProviderQuery;
import org.keycloak.models.KeycloakSession;

public class DefaultAlternativeLookupProvider
implements AlternativeLookupProvider {
    private final LocalCache<String, String> lookupCache;

    public DefaultAlternativeLookupProvider(LocalCache<String, String> lookupCache) {
        this.lookupCache = lookupCache;
    }

    public IdentityProviderModel lookupIdentityProviderFromIssuer(KeycloakSession session, String issuerUrl) {
        IdentityProviderModel idp;
        String alternativeKey = ComputedKey.computeKey(session.getContext().getRealm().getId(), "idp", issuerUrl);
        String cachedIdpAlias = (String)this.lookupCache.get((Object)alternativeKey);
        if (cachedIdpAlias != null) {
            idp = session.identityProviders().getByAlias(cachedIdpAlias);
            if (idp != null && issuerUrl.equals(idp.getConfig().get("issuer"))) {
                return idp;
            }
            this.lookupCache.invalidate((Object)alternativeKey);
        }
        if ((idp = (IdentityProviderModel)session.identityProviders().getAllStream(IdentityProviderQuery.any()).filter(i -> issuerUrl.equals(i.getConfig().get("issuer"))).findFirst().orElse(null)) != null && idp.getAlias() != null) {
            this.lookupCache.put((Object)alternativeKey, (Object)idp.getAlias());
        }
        return idp;
    }

    public ClientModel lookupClientFromClientAttributes(KeycloakSession session, Map<String, String> attributes) {
        ClientModel client;
        String alternativeKey = ComputedKey.computeKey(session.getContext().getRealm().getId(), "client", attributes);
        String cachedClientId = (String)this.lookupCache.get((Object)alternativeKey);
        if (cachedClientId != null) {
            boolean match;
            client = session.clients().getClientByClientId(session.getContext().getRealm(), cachedClientId);
            boolean bl = match = client != null;
            if (match) {
                for (Map.Entry<String, String> e : attributes.entrySet()) {
                    if (e.getValue().equals(client.getAttribute(e.getKey()))) continue;
                    match = false;
                    break;
                }
            }
            if (match) {
                return client;
            }
            this.lookupCache.invalidate((Object)alternativeKey);
        }
        client = null;
        List clients = session.clients().searchClientsByAttributes(session.getContext().getRealm(), attributes, Integer.valueOf(0), Integer.valueOf(2)).toList();
        if (clients.size() == 1) {
            client = (ClientModel)clients.get(0);
            this.lookupCache.put((Object)alternativeKey, (Object)client.getClientId());
        } else if (clients.size() > 1) {
            throw new RuntimeException("Multiple clients matches attributes");
        }
        return client;
    }

    public void close() {
    }
}

