/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.interfaces.ECPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.jboss.logging.Logger;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.AbstractEcKeyProviderFactory;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;

public abstract class AbstractGeneratedEcKeyProviderFactory<T extends KeyProvider>
extends AbstractEcKeyProviderFactory<T> {
    protected abstract String getDefaultEcEllipticCurve();

    protected abstract String getEcEllipticCurveKey();

    protected abstract String getEcEllipticCurveKey(String var1);

    protected abstract ProviderConfigProperty getEcEllipticCurveProperty();

    protected abstract String getEcPrivateKeyKey();

    protected abstract String getEcPublicKeyKey();

    protected abstract Logger getLogger();

    protected abstract boolean isSupportedEcAlgorithm(String var1);

    protected abstract boolean isValidKeyUse(KeyUse var1);

    public boolean createFallbackKeys(KeycloakSession session, KeyUse keyUse, String algorithm) {
        if (this.isValidKeyUse(keyUse) && this.isSupportedEcAlgorithm(algorithm)) {
            RealmModel realm = session.getContext().getRealm();
            ComponentModel generated = new ComponentModel();
            generated.setName("fallback-" + algorithm);
            generated.setParentId(realm.getId());
            generated.setProviderId(this.getId());
            generated.setProviderType(KeyProvider.class.getName());
            MultivaluedHashMap config = new MultivaluedHashMap();
            config.putSingle((Object)"priority", (Object)"-100");
            config.putSingle((Object)this.getEcEllipticCurveKey(), (Object)this.getEcEllipticCurveKey(algorithm));
            generated.setConfig(config);
            realm.addComponentModel(generated);
            return true;
        }
        return false;
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        super.validateConfiguration(session, realm, model);
        ConfigurationValidationHelper.check((ComponentModel)model).checkList(this.getEcEllipticCurveProperty(), false);
        String ecInNistRep = model.get(this.getEcEllipticCurveKey());
        if (ecInNistRep == null) {
            ecInNistRep = this.getDefaultEcEllipticCurve();
        }
        if (!model.contains(this.getEcPrivateKeyKey()) || !model.contains(this.getEcPublicKeyKey())) {
            this.generateKeys(model, ecInNistRep);
            this.getLogger().debugv("Generated keys for {0}", (Object)realm.getName());
        } else {
            String currentEc = this.getCurveFromPublicKey((String)model.getConfig().getFirst((Object)this.getEcPublicKeyKey()));
            if (!ecInNistRep.equals(currentEc)) {
                this.generateKeys(model, ecInNistRep);
                this.getLogger().debugv("Elliptic Curve changed, generating new keys for {0}", (Object)realm.getName());
            }
        }
    }

    protected void generateKeys(ComponentModel model, String ecInNistRep) {
        try {
            KeyPair keyPair = KeyUtils.generateEcKeyPair((String)AbstractGeneratedEcKeyProviderFactory.convertECDomainParmNistRepToSecRep(ecInNistRep));
            model.put(this.getEcPrivateKeyKey(), Base64.getEncoder().encodeToString(keyPair.getPrivate().getEncoded()));
            model.put(this.getEcPublicKeyKey(), Base64.getEncoder().encodeToString(keyPair.getPublic().getEncoded()));
            model.put(this.getEcEllipticCurveKey(), ecInNistRep);
        }
        catch (Throwable t) {
            throw new ComponentValidationException("Failed to generate EC keys", t);
        }
    }

    protected String getCurveFromPublicKey(String publicEcKeyBase64Encoded) {
        try {
            KeyFactory kf = KeyFactory.getInstance("EC");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicEcKeyBase64Encoded));
            ECPublicKey ecKey = (ECPublicKey)kf.generatePublic(publicKeySpec);
            return "P-" + ecKey.getParams().getCurve().getField().getFieldSize();
        }
        catch (Throwable t) {
            throw new ComponentValidationException("Failed to get EC from its public key", t);
        }
    }
}

