/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.executors;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.executors.ExecutorsProvider;
import org.keycloak.executors.ExecutorsProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class DefaultExecutorsProviderFactory
implements ExecutorsProviderFactory {
    protected static final Logger logger = Logger.getLogger(DefaultExecutorsProviderFactory.class);
    private static final int DEFAULT_MIN_THREADS = 4;
    private static final int DEFAULT_MAX_THREADS = 64;
    private static final String MANAGED_EXECUTORS_SERVICE_JNDI_PREFIX = "java:jboss/ee/concurrency/executor/";
    private static final String DEFAULT_MANAGED_EXECUTORS_SERVICE_JNDI = "java:jboss/ee/concurrency/executor/default";
    private Config.Scope config;
    private Boolean managed = null;
    private final Map<String, ExecutorService> executors = new ConcurrentHashMap<String, ExecutorService>();

    public ExecutorsProvider create(KeycloakSession session) {
        return new ExecutorsProvider(){

            public ExecutorService getExecutor(String taskType) {
                return DefaultExecutorsProviderFactory.this.getExecutor(taskType);
            }

            public void close() {
            }
        };
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        if (this.managed != null && !this.managed.booleanValue()) {
            for (Map.Entry<String, ExecutorService> executor : this.executors.entrySet()) {
                logger.debugf("Shutting down executor for task '%s'", (Object)executor.getKey());
                executor.getValue().shutdown();
            }
        }
    }

    public String getId() {
        return "default";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutorService getExecutor(String taskType) {
        ExecutorService existing = this.executors.get(taskType);
        if (existing == null) {
            DefaultExecutorsProviderFactory defaultExecutorsProviderFactory = this;
            synchronized (defaultExecutorsProviderFactory) {
                if (!this.executors.containsKey(taskType)) {
                    ExecutorService executor = this.retrievePool(taskType);
                    this.executors.put(taskType, executor);
                }
                existing = this.executors.get(taskType);
            }
        }
        return existing;
    }

    protected ExecutorService retrievePool(String taskType) {
        if (this.managed == null) {
            this.detectManaged();
        }
        if (this.managed.booleanValue()) {
            return this.getPoolManaged(taskType);
        }
        return this.createPoolEmbedded(taskType);
    }

    protected void detectManaged() {
        String jndiName = DEFAULT_MANAGED_EXECUTORS_SERVICE_JNDI;
        try {
            new InitialContext().lookup(jndiName);
            logger.debugf("We are in managed environment. Executor '%s' was available.", (Object)jndiName);
            this.managed = true;
        }
        catch (NamingException nnfe) {
            logger.debugf("We are not in managed environment. Executor '%s' was not available.", (Object)jndiName);
            this.managed = false;
        }
    }

    protected ExecutorService getPoolManaged(String taskType) {
        try {
            InitialContext ctx = new InitialContext();
            String jndiName = MANAGED_EXECUTORS_SERVICE_JNDI_PREFIX + taskType;
            try {
                ExecutorService executor = (ExecutorService)ctx.lookup(jndiName);
                logger.debugf("Found executor for '%s' under JNDI name '%s'", (Object)taskType, (Object)jndiName);
                return executor;
            }
            catch (NameNotFoundException nnfe) {
                logger.debugf("Not found executor for '%s' under specific JNDI name '%s'. Fallback to the default pool", (Object)taskType, (Object)jndiName);
                ExecutorService executor = (ExecutorService)ctx.lookup(DEFAULT_MANAGED_EXECUTORS_SERVICE_JNDI);
                logger.debugf("Found default executor for '%s' of JNDI name '%s'", (Object)taskType, (Object)DEFAULT_MANAGED_EXECUTORS_SERVICE_JNDI);
                return executor;
            }
        }
        catch (NamingException ne) {
            throw new IllegalStateException(ne);
        }
    }

    protected ExecutorService createPoolEmbedded(String taskType) {
        Config.Scope currentScope = this.config.scope(new String[]{taskType});
        int min = 4;
        int max = 64;
        if (currentScope != null) {
            min = currentScope.getInt("min", Integer.valueOf(4));
            max = currentScope.getInt("max", Integer.valueOf(64));
        }
        logger.debugf("Creating pool for task '%s': min=%d, max=%d", (Object)taskType, (Object)min, (Object)max);
        ThreadFactory threadFactory = this.createThreadFactory(taskType);
        if (min == max) {
            return Executors.newFixedThreadPool(min, threadFactory);
        }
        return new ThreadPoolExecutor(min, max, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    protected ThreadFactory createThreadFactory(final String taskType) {
        return new ThreadFactory(){
            private AtomicInteger i = new AtomicInteger(0);
            private int group = new Random().nextInt(2048);

            @Override
            public Thread newThread(Runnable r) {
                int threadNumber = this.i.getAndIncrement();
                String threadName = "kc-" + taskType + "-" + this.group + "-" + threadNumber;
                if (logger.isTraceEnabled()) {
                    logger.tracef("Creating thread: %s", (Object)threadName);
                }
                return new Thread(r, threadName);
            }
        };
    }
}

