/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.paypal;

import com.fasterxml.jackson.databind.JsonNode;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.http.simple.SimpleHttp;
import org.keycloak.models.KeycloakSession;
import org.keycloak.social.paypal.PayPalIdentityProviderConfig;

public class PayPalIdentityProvider
extends AbstractOAuth2IdentityProvider<PayPalIdentityProviderConfig>
implements SocialIdentityProvider<PayPalIdentityProviderConfig> {
    public static final String BASE_URL = "https://api.paypal.com/v1";
    public static final String AUTH_URL = "https://www.paypal.com/signin/authorize";
    public static final String TOKEN_RESOURCE = "/identity/openidconnect/tokenservice";
    public static final String PROFILE_RESOURCE = "/oauth2/token/userinfo?schema=openid";
    public static final String DEFAULT_SCOPE = "openid profile email";

    public PayPalIdentityProvider(KeycloakSession session, PayPalIdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(config.targetSandbox() ? "https://www.sandbox.paypal.com/signin/authorize" : AUTH_URL);
        config.setTokenUrl((config.targetSandbox() ? "https://api.sandbox.paypal.com/v1" : BASE_URL) + TOKEN_RESOURCE);
        config.setUserInfoUrl((config.targetSandbox() ? "https://api.sandbox.paypal.com/v1" : BASE_URL) + PROFILE_RESOURCE);
    }

    @Override
    protected boolean supportsExternalExchange() {
        return true;
    }

    @Override
    protected String getProfileEndpointForValidation(EventBuilder event) {
        return ((PayPalIdentityProviderConfig)this.getConfig()).getUserInfoUrl();
    }

    @Override
    protected BrokeredIdentityContext extractIdentityFromProfile(EventBuilder event, JsonNode profile) {
        BrokeredIdentityContext user = new BrokeredIdentityContext(this.getJsonProperty(profile, "user_id"), this.getConfig());
        user.setUsername(this.getJsonProperty(profile, "email"));
        user.setName(this.getJsonProperty(profile, "name"));
        user.setEmail(this.getJsonProperty(profile, "email"));
        user.setIdp((IdentityProvider)this);
        AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, ((PayPalIdentityProviderConfig)this.getConfig()).getAlias());
        return user;
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            JsonNode profile = SimpleHttp.create((KeycloakSession)this.session).doGet(((PayPalIdentityProviderConfig)this.getConfig()).getUserInfoUrl()).header("Authorization", "Bearer " + accessToken).asJson();
            return this.extractIdentityFromProfile(null, profile);
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from paypal.", (Throwable)e);
        }
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

