/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.spiffe;

import org.keycloak.crypto.PublicKeysWrapper;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.JWKSHttpUtils;
import org.keycloak.util.JWKSUtils;

public class SpiffeBundleEndpointLoader
implements PublicKeyLoader {
    private final KeycloakSession session;
    private final String bundleEndpoint;

    public SpiffeBundleEndpointLoader(KeycloakSession session, String bundleEndpoint) {
        this.session = session;
        this.bundleEndpoint = bundleEndpoint;
    }

    public PublicKeysWrapper loadKeys() throws Exception {
        JSONWebKeySet jwks = JWKSHttpUtils.sendJwksRequest(this.session, this.bundleEndpoint);
        PublicKeysWrapper keysWrapper = JWKSUtils.getKeyWrappersForUse((JSONWebKeySet)jwks, (JWK.Use)JWK.Use.JWT_SVID, (boolean)true);
        if (keysWrapper.getKeys().isEmpty()) {
            keysWrapper = JWKSUtils.getKeyWrappersForUse((JSONWebKeySet)jwks, (JWK.Use)JWK.Use.SIG, (boolean)true);
        }
        return keysWrapper;
    }
}

