/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.locale;

import jakarta.ws.rs.core.HttpHeaders;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.cookie.CookieProvider;
import org.keycloak.cookie.CookieType;
import org.keycloak.locale.LocaleSelectorProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.theme.Theme;

public class DefaultLocaleSelectorProvider
implements LocaleSelectorProvider {
    private static final Logger logger = Logger.getLogger(LocaleSelectorProvider.class);
    private KeycloakSession session;

    public DefaultLocaleSelectorProvider(KeycloakSession session) {
        this.session = session;
    }

    public Locale resolveLocale(RealmModel realm, UserModel user) {
        return this.resolveLocale(realm, user, null);
    }

    public Locale resolveLocale(RealmModel realm, UserModel user, Theme.Type themeType) {
        HttpHeaders requestHeaders = this.session.getContext().getRequestHeaders();
        AuthenticationSessionModel session = this.session.getContext().getAuthenticationSession();
        if (!realm.isInternationalizationEnabled()) {
            return Locale.ENGLISH;
        }
        Locale userLocale = this.getUserLocale(realm, session, user, requestHeaders, themeType);
        if (userLocale != null) {
            return userLocale;
        }
        String realmDefaultLocale = realm.getDefaultLocale();
        if (realmDefaultLocale != null) {
            return Locale.forLanguageTag(realmDefaultLocale);
        }
        return Locale.ENGLISH;
    }

    private Locale getUserLocale(RealmModel realm, AuthenticationSessionModel session, UserModel user, HttpHeaders requestHeaders, Theme.Type themeType) {
        Locale locale = this.getUserSelectedLocale(realm, session);
        if (locale != null) {
            return locale;
        }
        locale = this.getUserProfileSelection(realm, user);
        if (locale != null) {
            return locale;
        }
        if (Theme.Type.EMAIL.equals((Object)themeType)) {
            return null;
        }
        locale = this.getClientSelectedLocale(realm, session);
        if (locale != null) {
            return locale;
        }
        locale = this.getLocaleCookieSelection(realm, requestHeaders);
        if (locale != null) {
            return locale;
        }
        locale = this.getAcceptLanguageHeaderLocale(realm, requestHeaders);
        if (locale != null) {
            return locale;
        }
        return null;
    }

    private Locale getUserSelectedLocale(RealmModel realm, AuthenticationSessionModel session) {
        String locale;
        String string = locale = session == null ? (String)this.session.getAttribute("locale_user_requested", String.class) : session.getAuthNote("locale_user_requested");
        if (locale == null) {
            return null;
        }
        return this.findLocale(realm, locale);
    }

    private Locale getUserProfileSelection(RealmModel realm, UserModel user) {
        if (user == null) {
            return null;
        }
        String locale = user.getFirstAttribute("locale");
        if (locale == null) {
            return null;
        }
        return this.findLocale(realm, locale);
    }

    private Locale getClientSelectedLocale(RealmModel realm, AuthenticationSessionModel session) {
        if (session == null) {
            return null;
        }
        String locale = session.getClientNote("locale_client_requested");
        if (locale == null) {
            return null;
        }
        return this.findLocale(realm, locale.split(" "));
    }

    private Locale getLocaleCookieSelection(RealmModel realm, HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        String localeCookie = ((CookieProvider)this.session.getProvider(CookieProvider.class)).get(CookieType.LOCALE);
        if (localeCookie == null) {
            return null;
        }
        return this.findLocale(realm, localeCookie);
    }

    private Locale getAcceptLanguageHeaderLocale(RealmModel realm, HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        List acceptableLanguages = httpHeaders.getAcceptableLanguages();
        if (acceptableLanguages == null || acceptableLanguages.isEmpty()) {
            return null;
        }
        for (Locale l : acceptableLanguages) {
            Locale locale = this.findLocale(realm, l.toLanguageTag());
            if (locale == null) continue;
            return locale;
        }
        return null;
    }

    private Locale findLocale(RealmModel realm, String ... localeStrings) {
        List<Locale> supportedLocales = realm.getSupportedLocalesStream().map(Locale::forLanguageTag).collect(Collectors.toList());
        return DefaultLocaleSelectorProvider.findBestMatchingLocale(supportedLocales, localeStrings);
    }

    static Locale findBestMatchingLocale(List<Locale> supportedLocales, String ... localeStrings) {
        for (String localeString : localeStrings) {
            if (localeString == null) continue;
            Locale result = null;
            Locale search = Locale.forLanguageTag(localeString);
            for (Locale supportedLocale : supportedLocales) {
                if (!DefaultLocaleSelectorProvider.doesLocaleMatch(search, supportedLocale) || result != null && !DefaultLocaleSelectorProvider.doesFirstLocaleBetterMatchThanSecondLocale(supportedLocale, result, search)) continue;
                result = supportedLocale;
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static boolean doesLocaleMatch(Locale candidate, Locale supportedLocale) {
        return candidate.getLanguage().equals(supportedLocale.getLanguage()) && (candidate.getCountry().equals("") ^ supportedLocale.getCountry().equals("") || candidate.getCountry().equals(supportedLocale.getCountry()));
    }

    private static boolean doesFirstLocaleBetterMatchThanSecondLocale(Locale firstLocale, Locale secondLocale, Locale supportedLocale) {
        if (firstLocale.getLanguage().equals(supportedLocale.getLanguage()) && !secondLocale.getLanguage().equals(supportedLocale.getLanguage())) {
            return true;
        }
        if (firstLocale.getCountry().equals(supportedLocale.getCountry()) && !secondLocale.getCountry().equals(supportedLocale.getCountry())) {
            return true;
        }
        return firstLocale.getVariant().equals(supportedLocale.getVariant()) && !secondLocale.getVariant().equals(supportedLocale.getVariant());
    }

    public void close() {
    }
}

