/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;

public class ClientProtocolCondition
extends AbstractClientPolicyConditionProvider<Configuration> {
    public ClientProtocolCondition(KeycloakSession session) {
        super(session);
    }

    public String getProviderId() {
        return "client-access-type";
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: 
            case TOKEN_REQUEST: 
            case TOKEN_RESPONSE: 
            case SERVICE_ACCOUNT_TOKEN_REQUEST: 
            case SERVICE_ACCOUNT_TOKEN_RESPONSE: 
            case TOKEN_REFRESH: 
            case TOKEN_REFRESH_RESPONSE: 
            case TOKEN_REVOKE: 
            case TOKEN_INTROSPECT: 
            case USERINFO_REQUEST: 
            case LOGOUT_REQUEST: 
            case UPDATE: 
            case UPDATED: 
            case REGISTERED: 
            case SAML_AUTHN_REQUEST: 
            case SAML_LOGOUT_REQUEST: {
                if (this.isCorrectProtocolFromContext()) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
            case REGISTER: {
                if (this.isCorrectProtocolFromRepresentation((ClientCRUDContext)context)) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    public boolean isCorrectProtocolFromContext() {
        String protocol;
        ClientModel client = this.session.getContext().getClient();
        if (client != null && (protocol = client.getProtocol()) != null) {
            return protocol.equals(((Configuration)this.configuration).getProtocol());
        }
        return false;
    }

    public boolean isCorrectProtocolFromRepresentation(ClientCRUDContext context) {
        String protocol;
        ClientRepresentation clientRep = context.getProposedClientRepresentation();
        if (clientRep != null && (protocol = clientRep.getProtocol()) != null) {
            return protocol.equals(((Configuration)this.configuration).getProtocol());
        }
        return false;
    }

    public static class Configuration
    extends ClientPolicyConditionConfigurationRepresentation {
        protected String protocol;

        public Configuration() {
            this.protocol = null;
        }

        public Configuration(String protocol) {
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }
    }
}

