/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.keycloak.protocol.oid4vc.model.Claims;
import org.keycloak.protocol.oid4vc.model.CredentialBuildConfig;
import org.keycloak.protocol.oid4vc.model.CredentialConfigId;
import org.keycloak.protocol.oid4vc.model.CredentialDefinition;
import org.keycloak.protocol.oid4vc.model.DisplayObject;
import org.keycloak.protocol.oid4vc.model.ProofTypesSupported;
import org.keycloak.protocol.oid4vc.model.VerifiableCredentialType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SupportedCredentialConfiguration {
    public static final String DOT_SEPARATOR = ".";
    @JsonIgnore
    private static final String FORMAT_KEY = "format";
    @JsonIgnore
    private static final String SCOPE_KEY = "scope";
    @JsonIgnore
    private static final String CRYPTOGRAPHIC_BINDING_METHODS_SUPPORTED_KEY = "cryptographic_binding_methods_supported";
    @JsonIgnore
    private static final String CRYPTOGRAPHIC_SUITES_SUPPORTED_KEY = "cryptographic_suites_supported";
    @JsonIgnore
    private static final String CREDENTIAL_SIGNING_ALG_VALUES_SUPPORTED_KEY = "credential_signing_alg_values_supported";
    @JsonIgnore
    private static final String DISPLAY_KEY = "display";
    @JsonIgnore
    private static final String PROOF_TYPES_SUPPORTED_KEY = "proof_types_supported";
    @JsonIgnore
    private static final String CLAIMS_KEY = "claims";
    @JsonIgnore
    public static final String VERIFIABLE_CREDENTIAL_TYPE_KEY = "vct";
    @JsonIgnore
    private static final String CREDENTIAL_DEFINITION_KEY = "credential_definition";
    @JsonIgnore
    public static final String CREDENTIAL_BUILD_CONFIG_KEY = "credential_build_config";
    private String id;
    @JsonProperty(value="format")
    private String format;
    @JsonProperty(value="scope")
    private String scope;
    @JsonProperty(value="cryptographic_binding_methods_supported")
    private List<String> cryptographicBindingMethodsSupported;
    @JsonProperty(value="cryptographic_suites_supported")
    private List<String> cryptographicSuitesSupported;
    @JsonProperty(value="credential_signing_alg_values_supported")
    private List<String> credentialSigningAlgValuesSupported;
    @JsonProperty(value="display")
    private List<DisplayObject> display;
    @JsonProperty(value="vct")
    private String vct;
    @JsonProperty(value="credential_definition")
    private CredentialDefinition credentialDefinition;
    @JsonProperty(value="proof_types_supported")
    private ProofTypesSupported proofTypesSupported;
    @JsonProperty(value="claims")
    private Claims claims;
    @JsonIgnore
    private CredentialBuildConfig credentialBuildConfig;

    public String getFormat() {
        return this.format;
    }

    public VerifiableCredentialType deriveType() {
        if (Objects.equals(this.format, "vc+sd-jwt")) {
            return VerifiableCredentialType.from(this.vct);
        }
        return null;
    }

    public CredentialConfigId deriveConfiId() {
        return CredentialConfigId.from(this.id);
    }

    public SupportedCredentialConfiguration setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public SupportedCredentialConfiguration setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public List<String> getCryptographicBindingMethodsSupported() {
        return this.cryptographicBindingMethodsSupported;
    }

    public SupportedCredentialConfiguration setCryptographicBindingMethodsSupported(List<String> cryptographicBindingMethodsSupported) {
        this.cryptographicBindingMethodsSupported = Collections.unmodifiableList(cryptographicBindingMethodsSupported);
        return this;
    }

    public List<String> getCryptographicSuitesSupported() {
        return this.cryptographicSuitesSupported;
    }

    public SupportedCredentialConfiguration setCryptographicSuitesSupported(List<String> cryptographicSuitesSupported) {
        this.cryptographicSuitesSupported = Collections.unmodifiableList(cryptographicSuitesSupported);
        return this;
    }

    public List<DisplayObject> getDisplay() {
        return this.display;
    }

    public SupportedCredentialConfiguration setDisplay(List<DisplayObject> display) {
        this.display = display;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public SupportedCredentialConfiguration setId(String id) {
        if (id.contains(DOT_SEPARATOR)) {
            throw new IllegalArgumentException("dots are not supported as part of the supported credentials id.");
        }
        this.id = id;
        return this;
    }

    public List<String> getCredentialSigningAlgValuesSupported() {
        return this.credentialSigningAlgValuesSupported;
    }

    public SupportedCredentialConfiguration setCredentialSigningAlgValuesSupported(List<String> credentialSigningAlgValuesSupported) {
        this.credentialSigningAlgValuesSupported = Collections.unmodifiableList(credentialSigningAlgValuesSupported);
        return this;
    }

    public Claims getClaims() {
        return this.claims;
    }

    public SupportedCredentialConfiguration setClaims(Claims claims) {
        this.claims = claims;
        return this;
    }

    public String getVct() {
        return this.vct;
    }

    public SupportedCredentialConfiguration setVct(String vct) {
        this.vct = vct;
        return this;
    }

    public CredentialDefinition getCredentialDefinition() {
        return this.credentialDefinition;
    }

    public SupportedCredentialConfiguration setCredentialDefinition(CredentialDefinition credentialDefinition) {
        this.credentialDefinition = credentialDefinition;
        return this;
    }

    public ProofTypesSupported getProofTypesSupported() {
        return this.proofTypesSupported;
    }

    public SupportedCredentialConfiguration setProofTypesSupported(ProofTypesSupported proofTypesSupported) {
        this.proofTypesSupported = proofTypesSupported;
        return this;
    }

    public CredentialBuildConfig getCredentialBuildConfig() {
        return this.credentialBuildConfig;
    }

    public SupportedCredentialConfiguration setCredentialBuildConfig(CredentialBuildConfig credentialBuildConfig) {
        this.credentialBuildConfig = credentialBuildConfig;
        return this;
    }

    public Map<String, String> toDotNotation() {
        HashMap<String, String> dotNotation = new HashMap<String, String>();
        Optional.ofNullable(this.format).ifPresent(format -> dotNotation.put(this.id + ".format", (String)format));
        Optional.ofNullable(this.vct).ifPresent(vct -> dotNotation.put(this.id + ".vct", (String)vct));
        Optional.ofNullable(this.scope).ifPresent(scope -> dotNotation.put(this.id + ".scope", (String)scope));
        Optional.ofNullable(this.cryptographicBindingMethodsSupported).ifPresent(types -> dotNotation.put(this.id + ".cryptographic_binding_methods_supported", String.join((CharSequence)",", this.cryptographicBindingMethodsSupported)));
        Optional.ofNullable(this.cryptographicSuitesSupported).ifPresent(types -> dotNotation.put(this.id + ".cryptographic_suites_supported", String.join((CharSequence)",", this.cryptographicSuitesSupported)));
        Optional.ofNullable(this.cryptographicSuitesSupported).ifPresent(types -> dotNotation.put(this.id + ".credential_signing_alg_values_supported", String.join((CharSequence)",", this.credentialSigningAlgValuesSupported)));
        Optional.ofNullable(this.claims).ifPresent(c -> dotNotation.put(this.id + ".claims", c.toJsonString()));
        Optional.ofNullable(this.credentialDefinition).ifPresent(cdef -> dotNotation.put(this.id + ".credential_definition", cdef.toJsonString()));
        Optional.ofNullable(this.display).ifPresent(d -> d.stream().filter(Objects::nonNull).forEach(o -> dotNotation.put(this.id + ".display." + d.indexOf(o), o.toJsonString())));
        Optional.ofNullable(this.proofTypesSupported).ifPresent(p -> dotNotation.put(this.id + ".proof_types_supported", p.toJsonString()));
        Optional.ofNullable(this.credentialBuildConfig).ifPresent(p -> dotNotation.putAll(this.credentialBuildConfig.toDotNotation()));
        return dotNotation;
    }

    public static SupportedCredentialConfiguration fromDotNotation(String credentialId, Map<String, String> dotNotated) {
        SupportedCredentialConfiguration supportedCredentialConfiguration = new SupportedCredentialConfiguration().setId(credentialId);
        Optional.ofNullable(dotNotated.get(credentialId + ".format")).ifPresent(supportedCredentialConfiguration::setFormat);
        Optional.ofNullable(dotNotated.get(credentialId + ".vct")).ifPresent(supportedCredentialConfiguration::setVct);
        Optional.ofNullable(dotNotated.get(credentialId + ".scope")).ifPresent(supportedCredentialConfiguration::setScope);
        Optional.ofNullable(dotNotated.get(credentialId + ".cryptographic_binding_methods_supported")).map(cbms -> cbms.split(",")).map(Arrays::asList).ifPresent(supportedCredentialConfiguration::setCryptographicBindingMethodsSupported);
        Optional.ofNullable(dotNotated.get(credentialId + ".cryptographic_suites_supported")).map(css -> css.split(",")).map(Arrays::asList).ifPresent(supportedCredentialConfiguration::setCryptographicSuitesSupported);
        Optional.ofNullable(dotNotated.get(credentialId + ".credential_signing_alg_values_supported")).map(css -> css.split(",")).map(Arrays::asList).ifPresent(supportedCredentialConfiguration::setCredentialSigningAlgValuesSupported);
        Optional.ofNullable(dotNotated.get(credentialId + ".claims")).map(Claims::fromJsonString).ifPresent(supportedCredentialConfiguration::setClaims);
        Optional.ofNullable(dotNotated.get(credentialId + ".credential_definition")).map(CredentialDefinition::fromJsonString).ifPresent(supportedCredentialConfiguration::setCredentialDefinition);
        String displayKeyPrefix = credentialId + ".display.";
        List<DisplayObject> displayList = dotNotated.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(displayKeyPrefix)).sorted(Map.Entry.comparingByKey()).map(entry -> DisplayObject.fromJsonString((String)entry.getValue())).collect(Collectors.toList());
        if (!displayList.isEmpty()) {
            supportedCredentialConfiguration.setDisplay(displayList);
        }
        Optional.ofNullable(dotNotated.get(credentialId + ".proof_types_supported")).map(ProofTypesSupported::fromJsonString).ifPresent(supportedCredentialConfiguration::setProofTypesSupported);
        Optional.ofNullable(CredentialBuildConfig.fromDotNotation(credentialId, dotNotated)).ifPresent(supportedCredentialConfiguration::setCredentialBuildConfig);
        return supportedCredentialConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportedCredentialConfiguration that = (SupportedCredentialConfiguration)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.format, that.format) && Objects.equals(this.scope, that.scope) && Objects.equals(this.cryptographicBindingMethodsSupported, that.cryptographicBindingMethodsSupported) && Objects.equals(this.cryptographicSuitesSupported, that.cryptographicSuitesSupported) && Objects.equals(this.credentialSigningAlgValuesSupported, that.credentialSigningAlgValuesSupported) && Objects.equals(this.display, that.display) && Objects.equals(this.vct, that.vct) && Objects.equals(this.credentialDefinition, that.credentialDefinition) && Objects.equals(this.proofTypesSupported, that.proofTypesSupported) && Objects.equals(this.claims, that.claims) && Objects.equals(this.credentialBuildConfig, that.credentialBuildConfig);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.format, this.scope, this.cryptographicBindingMethodsSupported, this.cryptographicSuitesSupported, this.credentialSigningAlgValuesSupported, this.display, this.vct, this.credentialDefinition, this.proofTypesSupported, this.claims, this.credentialBuildConfig);
    }
}

