/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import java.util.List;
import java.util.Optional;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oid4vc.issuance.signing.SdJwtSigningService;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningProperties;
import org.keycloak.protocol.oid4vc.issuance.signing.VCSigningServiceProviderFactory;
import org.keycloak.protocol.oid4vc.issuance.signing.VerifiableCredentialsSigningService;
import org.keycloak.protocol.oid4vc.model.CredentialConfigId;
import org.keycloak.protocol.oid4vc.model.VerifiableCredentialType;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;

public class SdJwtSigningServiceProviderFactory
implements VCSigningServiceProviderFactory {
    public static final String SUPPORTED_FORMAT = "vc+sd-jwt";
    private static final String HELP_TEXT = "Issues SD-JWT-VCs following the specification of https://drafts.oauth.net/oauth-sd-jwt-vc/draft-ietf-oauth-sd-jwt-vc.html.";

    public VerifiableCredentialsSigningService create(KeycloakSession session, ComponentModel model) {
        String keyId = model.get(SigningProperties.KEY_ID.getKey());
        String algorithmType = model.get(SigningProperties.ALGORITHM_TYPE.getKey());
        Optional<String> kid = Optional.ofNullable(model.get(SigningProperties.KID_HEADER.getKey()));
        String vct = model.get(SigningProperties.VC_VCT.getKey());
        String vcConfigId = model.get(SigningProperties.VC_CONFIG_ID.getKey());
        return new SdJwtSigningService(session, keyId, algorithmType, kid, VerifiableCredentialType.from(vct), CredentialConfigId.from(vcConfigId));
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return VCSigningServiceProviderFactory.configurationBuilder().property(SigningProperties.ALGORITHM_TYPE.asConfigProperty()).property(SigningProperties.KID_HEADER.asConfigProperty()).property(SigningProperties.VC_VCT.asConfigProperty()).property(SigningProperties.VC_CONFIG_ID.asConfigProperty()).build();
    }

    public String getId() {
        return SUPPORTED_FORMAT;
    }

    @Override
    public void validateSpecificConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        ConfigurationValidationHelper helper = ConfigurationValidationHelper.check((ComponentModel)model).checkRequired(SigningProperties.ALGORITHM_TYPE.asConfigProperty());
        if (model.get(SigningProperties.VC_CONFIG_ID.getKey()) != null) {
            helper.checkRequired(SigningProperties.VC_VCT.asConfigProperty());
        }
    }

    @Override
    public String supportedFormat() {
        return SUPPORTED_FORMAT;
    }
}

