/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.truststore;

import java.io.File;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.enums.HostnameVerificationPolicy;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.truststore.FileTruststoreProvider;
import org.keycloak.truststore.TruststoreBuilder;
import org.keycloak.truststore.TruststoreProvider;
import org.keycloak.truststore.TruststoreProviderFactory;
import org.keycloak.truststore.TruststoreProviderSingleton;

public class FileTruststoreProviderFactory
implements TruststoreProviderFactory {
    static final String HOSTNAME_VERIFICATION_POLICY = "hostname-verification-policy";
    private static final Logger log = Logger.getLogger(FileTruststoreProviderFactory.class);
    private TruststoreProvider provider;

    public TruststoreProvider create(KeycloakSession session) {
        return this.provider;
    }

    public void setProvider(TruststoreProvider provider) {
        this.provider = provider;
    }

    public void init(Config.Scope config) {
        String type;
        KeyStore truststore;
        HostnameVerificationPolicy verificationPolicy;
        String policy;
        String storepath;
        block13: {
            storepath = config.get("file");
            String pass = config.get("password");
            policy = config.get(HOSTNAME_VERIFICATION_POLICY);
            String configuredType = config.get("type");
            if (storepath != null || pass != null || configuredType != null) {
                log.warn((Object)"Using deprecated 'spi-truststore-file-*' options. Consider using 'truststore-paths' option.");
            }
            verificationPolicy = null;
            truststore = null;
            boolean system = false;
            if (storepath == null) {
                storepath = System.getProperty("javax.net.ssl.trustStore");
                if (storepath == null) {
                    File defaultTrustStore = TruststoreBuilder.getJRETruststore();
                    if (!defaultTrustStore.exists()) {
                        throw new RuntimeException("Attribute 'file' missing in 'truststore':'file' configuration, and could not find the system truststore");
                    }
                    storepath = defaultTrustStore.getAbsolutePath();
                    system = true;
                }
                pass = System.getProperty("javax.net.ssl.trustStorePassword", system ? "changeit" : null);
                configuredType = System.getProperty("javax.net.ssl.trustStoreType");
            }
            type = KeystoreUtil.getKeystoreType((String)configuredType, (String)storepath, (String)KeyStore.getDefaultType());
            try {
                truststore = KeystoreUtil.loadKeyStore((String)storepath, (String)pass, (String)type);
            }
            catch (Exception e) {
                if (system && !"jks".equalsIgnoreCase(type)) {
                    try {
                        truststore = KeystoreUtil.loadKeyStore((String)storepath, (String)pass, (String)"jks");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (truststore != null) break block13;
                throw new RuntimeException("Failed to initialize TruststoreProviderFactory: " + new File(storepath).getAbsolutePath() + ", truststore type: " + type, e);
            }
        }
        if (policy == null) {
            verificationPolicy = HostnameVerificationPolicy.DEFAULT;
        } else {
            try {
                verificationPolicy = HostnameVerificationPolicy.valueOf((String)policy);
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid value for 'hostname-verification-policy': " + policy + " (must be one of: " + Stream.of(HostnameVerificationPolicy.values()).map(Enum::name).collect(Collectors.joining(", ")) + ")");
            }
        }
        TruststoreCertificatesLoader certsLoader = new TruststoreCertificatesLoader(truststore);
        this.provider = new FileTruststoreProvider(truststore, verificationPolicy, Collections.unmodifiableMap(certsLoader.trustedRootCerts), Collections.unmodifiableMap(certsLoader.intermediateCerts));
        TruststoreProviderSingleton.set(this.provider);
        log.debugf("File truststore provider initialized: %s, Truststore type: %s", (Object)new File(storepath).getAbsolutePath(), (Object)type);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "file";
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("file").type("string").helpText("DEPRECATED: The file path of the trust store from where the certificates are going to be read from to validate TLS connections.").add().property().name("password").type("string").helpText("DEPRECATED: The trust store password.").add().property().name(HOSTNAME_VERIFICATION_POLICY).type("string").helpText("DEPRECATED: The hostname verification policy.").options((String[])Arrays.stream(HostnameVerificationPolicy.values()).map(Enum::name).toArray(String[]::new)).defaultValue((Object)HostnameVerificationPolicy.DEFAULT.name()).add().property().name("type").type("string").helpText("DEPRECATED: Type of the truststore. If not provided, the type would be detected based on the truststore file extension or platform default type.").add().build();
    }

    private static class TruststoreCertificatesLoader {
        private Map<X500Principal, List<X509Certificate>> trustedRootCerts = new HashMap<X500Principal, List<X509Certificate>>();
        private Map<X500Principal, List<X509Certificate>> intermediateCerts = new HashMap<X500Principal, List<X509Certificate>>();

        public TruststoreCertificatesLoader(KeyStore truststore) {
            this.readTruststore(truststore);
        }

        private void readTruststore(KeyStore truststore) {
            try {
                Enumeration<String> enumeration = truststore.aliases();
                log.trace((Object)("Checking " + truststore.size() + " entries from the truststore."));
                while (enumeration.hasMoreElements()) {
                    String alias = enumeration.nextElement();
                    this.readTruststoreEntry(truststore, alias);
                }
            }
            catch (KeyStoreException e) {
                log.error((Object)("Error while reading Keycloak truststore " + e.getMessage()), (Throwable)e);
            }
        }

        private void readTruststoreEntry(KeyStore truststore, String alias) {
            try {
                Certificate certificate = truststore.getCertificate(alias);
                if (certificate instanceof X509Certificate) {
                    X509Certificate cax509cert = (X509Certificate)certificate;
                    if (this.isSelfSigned(cax509cert)) {
                        X500Principal principal = cax509cert.getSubjectX500Principal();
                        List<X509Certificate> certs = this.trustedRootCerts.get(principal);
                        if (certs == null) {
                            certs = new ArrayList<X509Certificate>();
                            this.trustedRootCerts.put(principal, certs);
                        }
                        certs.add(cax509cert);
                        log.debug((Object)("Trusted root CA found in truststore : alias : " + alias + " | Subject DN : " + principal));
                    } else {
                        X500Principal principal = cax509cert.getSubjectX500Principal();
                        List<X509Certificate> certs = this.intermediateCerts.get(principal);
                        if (certs == null) {
                            certs = new ArrayList<X509Certificate>();
                            this.intermediateCerts.put(principal, certs);
                        }
                        certs.add(cax509cert);
                        log.debug((Object)("Intermediate CA found in truststore : alias : " + alias + " | Subject DN : " + principal));
                    }
                } else {
                    log.info((Object)("Skipping certificate with alias [" + alias + "] from truststore, because it's not an X509Certificate"));
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
                log.warnf("Error while reading Keycloak truststore entry [%s]. Exception message: %s", (Object)alias, (Object)e.getMessage(), (Object)e);
            }
        }

        private boolean isSelfSigned(X509Certificate cert) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
            try {
                PublicKey key = cert.getPublicKey();
                cert.verify(key);
                log.trace((Object)("certificate " + cert.getSubjectDN() + " detected as root CA"));
                return true;
            }
            catch (SignatureException sigEx) {
                log.trace((Object)("certificate " + cert.getSubjectDN() + " detected as intermediate CA"));
            }
            catch (InvalidKeyException keyEx) {
                log.trace((Object)("certificate " + cert.getSubjectDN() + " detected as intermediate CA"));
            }
            return false;
        }
    }
}

