/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.transaction;

import jakarta.transaction.RollbackException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.provider.ExceptionConverter;
import org.keycloak.transaction.RequestContextHelper;

public class JtaTransactionWrapper
implements KeycloakTransaction {
    private static final Logger logger = Logger.getLogger(JtaTransactionWrapper.class);
    protected TransactionManager tm;
    protected Transaction ut;
    protected Transaction suspended;
    protected Exception ended;
    protected KeycloakSession session;
    private final RequestContextHelper requestContextHelper;

    public JtaTransactionWrapper(KeycloakSession session, TransactionManager tm) {
        this.tm = tm;
        this.session = session;
        this.requestContextHelper = RequestContextHelper.getContext((KeycloakSession)session);
        try {
            this.suspended = tm.suspend();
            tm.begin();
            this.ut = tm.getTransaction();
            if (logger.isDebugEnabled()) {
                String messageToLog = "new JtaTransactionWrapper. Was existing transaction suspended: " + (this.suspended != null);
                if (this.suspended != null) {
                    messageToLog = messageToLog + " Suspended transaction: " + this.suspended + ". ";
                }
                this.logMessage(messageToLog);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void handleException(Throwable e) {
        if (e instanceof RollbackException) {
            e = e.getCause() != null ? e.getCause() : e;
        }
        Throwable finalE = e;
        logger.error((Object)this.getDetailedMessage("Exception during transaction operation."));
        this.session.getKeycloakSessionFactory().getProviderFactoriesStream(ExceptionConverter.class).map(factory -> ((ExceptionConverter)factory).convert(finalE)).filter(Objects::nonNull).forEach(throwable -> {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException((Throwable)throwable);
        });
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public void begin() {
    }

    public void commit() {
        try {
            this.logMessage("JtaTransactionWrapper  commit.");
            this.tm.commit();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.end();
        }
    }

    public void rollback() {
        try {
            this.logMessage("JtaTransactionWrapper rollback.");
            this.tm.rollback();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.end();
        }
    }

    public void setRollbackOnly() {
        try {
            this.tm.setRollbackOnly();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public boolean getRollbackOnly() {
        try {
            return this.tm.getStatus() == 1;
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    public boolean isActive() {
        try {
            return this.tm.getStatus() == 0;
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    protected void end() {
        this.ended = null;
        this.logMessage("JtaTransactionWrapper end.");
        if (this.suspended != null) {
            try {
                logger.debugf("JtaTransactionWrapper resuming suspended user transaction: %s", (Object)this.suspended);
                this.tm.resume(this.suspended);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void logMessage(String messageBase) {
        if (logger.isTraceEnabled()) {
            String msg = this.getDetailedMessage(messageBase);
            logger.debug((Object)msg);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)(messageBase + " Request Context: " + this.requestContextHelper.getContextInfo()));
        }
    }

    private String getDetailedMessage(String messageBase) {
        String msg = messageBase + " Request context: " + this.requestContextHelper.getDetailedContextInfo();
        if (this.ut != null) {
            msg = msg + ", Transaction: " + this.ut;
        }
        return msg;
    }
}

