/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.protocol.mappers.oidc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.protocol.mappers.oidc.OrganizationScope;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.TokenIntrospectionTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;

public class OrganizationMembershipMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper,
UserInfoTokenMapper,
TokenIntrospectionTokenMapper,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "oidc-organization-membership-mapper";
    public static final String ADD_ORGANIZATION_ATTRIBUTES = "addOrganizationAttributes";
    public static final String ADD_ORGANIZATION_ID = "addOrganizationId";

    public List<ProviderConfigProperty> getConfigProperties() {
        ArrayList<ProviderConfigProperty> properties = new ArrayList<ProviderConfigProperty>();
        OIDCAttributeMapperHelper.addTokenClaimNameConfig(properties);
        OIDCAttributeMapperHelper.addIncludeInTokensConfig(properties, OrganizationMembershipMapper.class);
        OIDCAttributeMapperHelper.addJsonTypeConfig(properties, List.of("String", "JSON"), "String");
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("multivalued");
        property.setLabel("multivalued.label");
        property.setHelpText("multivalued.tooltip");
        property.setType("boolean");
        property.setDefaultValue((Object)Boolean.TRUE.toString());
        properties.add(property);
        property = new ProviderConfigProperty();
        property.setName(ADD_ORGANIZATION_ATTRIBUTES);
        property.setLabel("addOrganizationAttributes.label");
        property.setType("boolean");
        property.setDefaultValue((Object)Boolean.FALSE.toString());
        property.setHelpText("addOrganizationAttributes.help");
        properties.add(property);
        property = new ProviderConfigProperty();
        property.setName(ADD_ORGANIZATION_ID);
        property.setLabel("addOrganizationId.label");
        property.setType("boolean");
        property.setDefaultValue((Object)Boolean.FALSE.toString());
        property.setHelpText("addOrganizationId.help");
        properties.add(property);
        return properties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Organization Membership";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map user Organization membership";
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel model, UserSessionModel userSession, KeycloakSession session, ClientSessionContext clientSessionCtx) {
        String orgId = clientSessionCtx.getClientSession().getNote("kc.org");
        Stream<OrganizationModel> organizations = orgId == null ? this.resolveFromRequestedScopes(session, userSession, clientSessionCtx) : Stream.of(((OrganizationProvider)session.getProvider(OrganizationProvider.class)).getById(orgId));
        KeycloakContext context = session.getContext();
        RealmModel realm = context.getRealm();
        ProtocolMapperModel effectiveModel = this.getEffectiveModel(session, realm, model);
        Object claim = this.resolveValue(effectiveModel, organizations.toList());
        if (claim == null) {
            return;
        }
        OIDCAttributeMapperHelper.mapClaim(token, effectiveModel, claim);
    }

    private Stream<OrganizationModel> resolveFromRequestedScopes(KeycloakSession session, UserSessionModel userSession, ClientSessionContext context) {
        String rawScopes = context.getScopeString();
        OrganizationScope scope = OrganizationScope.valueOfScope(rawScopes);
        if (scope == null) {
            return Stream.empty();
        }
        return scope.resolveOrganizations(userSession.getUser(), rawScopes, session);
    }

    private Object resolveValue(ProtocolMapperModel model, List<OrganizationModel> organizations) {
        if (organizations.isEmpty()) {
            return null;
        }
        if (!OIDCAttributeMapperHelper.isMultivalued(model)) {
            return organizations.get(0).getAlias();
        }
        HashMap value = new HashMap();
        for (OrganizationModel o : organizations) {
            if (o == null || !o.isEnabled()) continue;
            HashMap<String, String> claims = new HashMap<String, String>();
            if (this.isAddOrganizationId(model)) {
                claims.put("id", o.getId());
            }
            if (this.isAddOrganizationAttributes(model)) {
                claims.putAll(o.getAttributes());
            }
            value.put(o.getAlias(), claims);
        }
        if (value.isEmpty()) {
            return null;
        }
        if (OrganizationMembershipMapper.isJsonType(model)) {
            return value;
        }
        return value.keySet();
    }

    private static boolean isJsonType(ProtocolMapperModel model) {
        return "JSON".equals(model.getConfig().getOrDefault("jsonType.label", "JSON"));
    }

    @Override
    public ProtocolMapperModel getEffectiveModel(KeycloakSession session, RealmModel realm, ProtocolMapperModel model) {
        ProtocolMapperModel copy = RepresentationToModel.toModel((ProtocolMapperRepresentation)ModelToRepresentation.toRepresentation((ProtocolMapperModel)model));
        Map config = Optional.ofNullable(copy.getConfig()).orElseGet(HashMap::new);
        config.putIfAbsent("jsonType.label", "String");
        if (!OIDCAttributeMapperHelper.isMultivalued(copy)) {
            config.put(ADD_ORGANIZATION_ATTRIBUTES, Boolean.FALSE.toString());
            config.put(ADD_ORGANIZATION_ID, Boolean.FALSE.toString());
        }
        if (this.isAddOrganizationAttributes(copy) || this.isAddOrganizationId(copy)) {
            config.put("jsonType.label", "JSON");
        }
        this.setDefaultValues(config);
        return copy;
    }

    private void setDefaultValues(Map<String, String> config) {
        config.putIfAbsent("claim.name", "organization");
        for (ProviderConfigProperty property : this.getConfigProperties()) {
            Object defaultValue = property.getDefaultValue();
            if (defaultValue == null) continue;
            config.putIfAbsent("multivalued", defaultValue.toString());
        }
    }

    private boolean isAddOrganizationAttributes(ProtocolMapperModel model) {
        return Boolean.parseBoolean(model.getConfig().getOrDefault(ADD_ORGANIZATION_ATTRIBUTES, Boolean.FALSE.toString()));
    }

    private boolean isAddOrganizationId(ProtocolMapperModel model) {
        return Boolean.parseBoolean(model.getConfig().getOrDefault(ADD_ORGANIZATION_ID, Boolean.FALSE.toString()));
    }

    public static ProtocolMapperModel create(String name, boolean accessToken, boolean idToken, boolean introspectionEndpoint) {
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(PROVIDER_ID);
        mapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        if (accessToken) {
            config.put("access.token.claim", "true");
        }
        if (idToken) {
            config.put("id.token.claim", "true");
        }
        if (introspectionEndpoint) {
            config.put("introspection.token.claim", "true");
        }
        config.put("claim.name", "organization");
        config.put("jsonType.label", "String");
        config.put("multivalued", Boolean.TRUE.toString());
        mapper.setConfig(config);
        return mapper;
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION);
    }
}

