/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.authentication.authenticators.browser;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.authenticators.browser.IdentityProviderAuthenticator;
import org.keycloak.email.freemarker.beans.ProfileBean;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.forms.login.freemarker.model.AuthenticationContextBean;
import org.keycloak.forms.login.freemarker.model.IdentityProviderBean;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.forms.login.freemarker.model.OrganizationAwareAuthenticationContextBean;
import org.keycloak.organization.forms.login.freemarker.model.OrganizationAwareIdentityProviderBean;
import org.keycloak.organization.forms.login.freemarker.model.OrganizationAwareRealmBean;
import org.keycloak.organization.protocol.mappers.oidc.OrganizationScope;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.sessions.AuthenticationSessionModel;

public class OrganizationAuthenticator
extends IdentityProviderAuthenticator {
    private final KeycloakSession session;

    public OrganizationAuthenticator(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public void authenticate(AuthenticationFlowContext context) {
        OrganizationProvider provider = this.getOrganizationProvider();
        if (!Organizations.isEnabledAndOrganizationsPresent(provider)) {
            context.attempted();
            return;
        }
        OrganizationModel organization = Organizations.resolveOrganization(this.session);
        if (organization == null) {
            this.initialChallenge(context);
        } else {
            AuthenticationSessionModel authSession = context.getAuthenticationSession();
            authSession.setAuthNote("kc.org", organization.getId());
            this.action(context);
        }
    }

    @Override
    public void action(AuthenticationFlowContext context) {
        String domain;
        HttpRequest request = context.getHttpRequest();
        MultivaluedMap parameters = request.getDecodedFormParameters();
        String username = (String)parameters.getFirst((Object)"username");
        RealmModel realm = context.getRealm();
        UserModel user = this.resolveUser(context, username);
        OrganizationModel organization = this.resolveOrganization(user, domain = Organizations.getEmailDomain(username));
        if (organization == null) {
            if (this.shouldUserSelectOrganization(context, user)) {
                return;
            }
            context.attempted();
            return;
        }
        this.session.getContext().setOrganization(organization);
        if (this.tryRedirectBroker(context, organization, user, username, domain)) {
            return;
        }
        if (user == null) {
            this.unknownUserChallenge(context, organization, realm, domain != null);
            return;
        }
        if (!user.isEnabled()) {
            context.failure(AuthenticationFlowError.INVALID_USER);
            return;
        }
        if (AuthenticatorUtil.isSSOAuthentication(context.getAuthenticationSession())) {
            context.success();
        } else {
            context.attempted();
        }
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return realm.isOrganizationsEnabled();
    }

    private OrganizationModel resolveOrganization(UserModel user, String domain) {
        KeycloakContext context = this.session.getContext();
        HttpRequest request = context.getHttpRequest();
        MultivaluedMap parameters = request.getDecodedFormParameters();
        List alias = (List)parameters.getOrDefault((Object)"kc.org", List.of());
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        if (alias.isEmpty()) {
            OrganizationModel organization = Organizations.resolveOrganization(this.session, user, domain);
            if (organization != null) {
                authSession.setClientNote("kc.org", organization.getId());
            }
            return organization;
        }
        OrganizationProvider provider = this.getOrganizationProvider();
        OrganizationModel organization = provider.getByAlias((String)alias.get(0));
        if (organization == null) {
            return null;
        }
        authSession.setClientNote("kc.org", organization.getId());
        return organization;
    }

    private boolean shouldUserSelectOrganization(AuthenticationFlowContext context, UserModel user) {
        OrganizationProvider provider = this.getOrganizationProvider();
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        String rawScope = authSession.getClientNote("scope");
        OrganizationScope scope = OrganizationScope.valueOfScope(rawScope);
        if (!OrganizationScope.ANY.equals((Object)scope) || user == null) {
            return false;
        }
        if (authSession.getClientNote("kc.org") != null) {
            return false;
        }
        Stream organizations = provider.getByMember(user);
        if (organizations.count() > 1L) {
            LoginFormsProvider form = context.form();
            form.setAttribute("user", (Object)new ProfileBean(user, this.session));
            form.setAttributeMapper((Function)new Function<Map<String, Object>, Map<String, Object>>(){

                @Override
                public Map<String, Object> apply(Map<String, Object> attributes) {
                    attributes.computeIfPresent("auth", (key, bean) -> new OrganizationAwareAuthenticationContextBean((AuthenticationContextBean)bean, false));
                    return attributes;
                }
            });
            context.challenge(form.createForm("select-organization.ftl"));
            return true;
        }
        return false;
    }

    private boolean tryRedirectBroker(AuthenticationFlowContext context, OrganizationModel organization, UserModel user, String username, String domain) {
        if (user != null && user.credentialManager().getStoredCredentialsStream().findAny().isPresent()) {
            return false;
        }
        List<IdentityProviderModel> broker = Organizations.resolveHomeBroker(this.session, user);
        if (broker.size() == 1) {
            this.redirect(context, broker.get(0).getAlias(), user.getEmail());
            return true;
        }
        return this.redirect(context, organization, username, domain);
    }

    private boolean redirect(AuthenticationFlowContext context, OrganizationModel organization, String username, String domain) {
        if (domain == null) {
            return false;
        }
        List brokers = organization.getIdentityProviders().toList();
        for (IdentityProviderModel broker : brokers) {
            String idpDomain;
            if (!OrganizationModel.IdentityProviderRedirectMode.EMAIL_MATCH.isSet(broker) || !domain.equals(idpDomain = (String)broker.getConfig().get("kc.org.domain"))) continue;
            this.redirect(context, broker.getAlias(), username);
            return true;
        }
        return false;
    }

    private UserModel resolveUser(AuthenticationFlowContext context, String username) {
        if (context.getUser() != null) {
            return context.getUser();
        }
        if (username == null) {
            return null;
        }
        UserProvider users = this.session.users();
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = Optional.ofNullable(users.getUserByEmail(realm, username)).orElseGet(() -> users.getUserByUsername(realm, username));
        context.setUser(user);
        return user;
    }

    private void unknownUserChallenge(AuthenticationFlowContext context, OrganizationModel organization, RealmModel realm, boolean domainMatch) {
        LoginFormsProvider form = context.form().setAttributeMapper(attributes -> {
            if (this.hasPublicBrokers(organization)) {
                attributes.computeIfPresent("social", (key, bean) -> new OrganizationAwareIdentityProviderBean((IdentityProviderBean)bean, true));
                attributes.computeIfPresent("realm", (key, bean) -> new OrganizationAwareRealmBean(realm));
            } else {
                attributes.computeIfPresent("social", (key, bean) -> new OrganizationAwareIdentityProviderBean((IdentityProviderBean)bean, false, true));
            }
            attributes.computeIfPresent("auth", (key, bean) -> new OrganizationAwareAuthenticationContextBean((AuthenticationContextBean)bean, false));
            return attributes;
        });
        if (domainMatch) {
            form.addError(new FormMessage("Your email domain matches the " + organization.getName() + " organization but you don't have an account yet.", new Object[0]));
        }
        context.challenge(form.createLoginUsername());
    }

    private void initialChallenge(AuthenticationFlowContext context) {
        UserModel user = context.getUser();
        if (user == null) {
            LoginFormsProvider form = context.form().setAttributeMapper(attributes -> {
                attributes.computeIfPresent("social", (key, bean) -> new OrganizationAwareIdentityProviderBean((IdentityProviderBean)bean, false, true));
                attributes.computeIfPresent("auth", (key, bean) -> new OrganizationAwareAuthenticationContextBean((AuthenticationContextBean)bean, false));
                return attributes;
            });
            context.challenge(form.createLoginUsername());
        } else if (AuthenticatorUtil.isSSOAuthentication(context.getAuthenticationSession())) {
            if (this.shouldUserSelectOrganization(context, user)) {
                return;
            }
            context.success();
        } else {
            context.attempted();
        }
    }

    private boolean hasPublicBrokers(OrganizationModel organization) {
        return organization.getIdentityProviders().anyMatch(Predicate.not(IdentityProviderModel::isHideOnLogin));
    }

    private OrganizationProvider getOrganizationProvider() {
        return (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
    }
}

