/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import jakarta.ws.rs.ForbiddenException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.services.resources.admin.permissions.Helper;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;
import org.keycloak.services.resources.admin.permissions.RolePermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.RolePermissionManagement;

class RolePermissions
implements RolePermissionEvaluator,
RolePermissionManagement {
    private static final Logger logger = Logger.getLogger(RolePermissions.class);
    protected final KeycloakSession session;
    protected final RealmModel realm;
    protected final AuthorizationProvider authz;
    protected final MgmtPermissions root;
    private final ResourceStore resourceStore;
    private static final String RESOURCE_NAME_PREFIX = "role.resource.";

    public RolePermissions(KeycloakSession session, RealmModel realm, AuthorizationProvider authz, MgmtPermissions root) {
        this.session = session;
        this.realm = realm;
        this.authz = authz;
        this.root = root;
        this.resourceStore = authz != null ? authz.getStoreFactory().getResourceStore() : null;
    }

    @Override
    public boolean isPermissionsEnabled(RoleModel role) {
        return this.mapRolePermission(role) != null;
    }

    @Override
    public void setPermissionsEnabled(RoleModel role, boolean enable) {
        if (enable) {
            this.initialize(role);
        } else {
            this.disablePermissions(role);
        }
    }

    private void disablePermissions(RoleModel role) {
        Resource resource;
        ResourceServer server = this.resourceServer(role);
        if (server == null) {
            return;
        }
        Policy policy = this.mapRolePermission(role);
        if (policy != null) {
            this.authz.getStoreFactory().getPolicyStore().delete(policy.getId());
        }
        if ((policy = this.mapClientScopePermission(role)) != null) {
            this.authz.getStoreFactory().getPolicyStore().delete(policy.getId());
        }
        if ((policy = this.mapCompositePermission(role)) != null) {
            this.authz.getStoreFactory().getPolicyStore().delete(policy.getId());
        }
        if ((resource = this.authz.getStoreFactory().getResourceStore().findByName(server, RolePermissions.getRoleResourceName(role))) != null) {
            this.authz.getStoreFactory().getResourceStore().delete(resource.getId());
        }
    }

    @Override
    public Map<String, String> getPermissions(RoleModel role) {
        if (this.authz == null) {
            return null;
        }
        this.initialize(role);
        LinkedHashMap<String, String> scopes = new LinkedHashMap<String, String>();
        scopes.put("map-role", this.mapRolePermission(role).getId());
        scopes.put("map-role-client-scope", this.mapClientScopePermission(role).getId());
        scopes.put("map-role-composite", this.mapCompositePermission(role).getId());
        return scopes;
    }

    @Override
    public Policy mapRolePermission(RoleModel role) {
        ResourceServer server = this.resourceServer(role);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getMapRolePermissionName(role));
    }

    @Override
    public Policy mapCompositePermission(RoleModel role) {
        ResourceServer server = this.resourceServer(role);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getMapCompositePermissionName(role));
    }

    @Override
    public Policy mapClientScopePermission(RoleModel role) {
        ResourceServer server = this.resourceServer(role);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getMapClientScopePermissionName(role));
    }

    @Override
    public Resource resource(RoleModel role) {
        ResourceServer server = this.resourceServer(role);
        if (server == null) {
            return null;
        }
        ResourceStore resourceStore = this.authz.getStoreFactory().getResourceStore();
        return resourceStore.findByName(server, RolePermissions.getRoleResourceName(role));
    }

    @Override
    public ResourceServer resourceServer(RoleModel role) {
        ClientModel client = this.getRoleClient(role);
        return this.root.resourceServer(client);
    }

    private boolean checkAdminRoles(RoleModel role) {
        if (AdminRoles.ALL_ROLES.contains(role.getName())) {
            ClientModel container;
            RealmModel realm;
            if (this.root.admin().hasRole(role)) {
                return true;
            }
            ClientModel adminClient = this.root.getRealmManagementClient();
            if (adminClient.equals(role.getContainer())) {
                if (role.getName().equals(AdminRoles.MANAGE_CLIENTS) || role.getName().equals(AdminRoles.CREATE_CLIENT)) {
                    if (!this.root.clients().canManage()) {
                        return this.adminConflictMessage(role);
                    }
                    return true;
                }
                if (role.getName().equals(AdminRoles.VIEW_CLIENTS)) {
                    if (!this.root.clients().canView()) {
                        return this.adminConflictMessage(role);
                    }
                    return true;
                }
                if (role.getName().equals(AdminRoles.QUERY_REALMS)) {
                    return true;
                }
                if (role.getName().equals(AdminRoles.QUERY_CLIENTS)) {
                    return true;
                }
                if (role.getName().equals(AdminRoles.QUERY_USERS)) {
                    return true;
                }
                if (role.getName().equals(AdminRoles.QUERY_GROUPS)) {
                    return true;
                }
                if (role.getName().equals(AdminRoles.MANAGE_AUTHORIZATION)) {
                    if (!this.root.realm().canManageAuthorization()) {
                        return this.adminConflictMessage(role);
                    }
                    return true;
                }
                if (role.getName().equals(AdminRoles.VIEW_AUTHORIZATION)) {
                    if (!this.root.realm().canViewAuthorization()) {
                        return this.adminConflictMessage(role);
                    }
                    return true;
                }
                if (role.getName().equals(AdminRoles.MANAGE_EVENTS)) {
                    if (!this.root.realm().canManageEvents()) {
                        return this.adminConflictMessage(role);
                    }
                    return true;
                }
                if (role.getName().equals(AdminRoles.VIEW_EVENTS)) {
                    if (!this.root.realm().canViewEvents()) {
                        return this.adminConflictMessage(role);
                    }
                    return true;
                }
                if (role.getName().equals(AdminRoles.MANAGE_USERS)) {
                    if (!this.root.users().canManage()) {
                        return this.adminConflictMessage(role);
                    }
                    return true;
                }
                if (role.getName().equals(AdminRoles.VIEW_USERS)) {
                    if (!this.root.users().canView()) {
                        return this.adminConflictMessage(role);
                    }
                    return true;
                }
                if (role.getName().equals(AdminRoles.MANAGE_IDENTITY_PROVIDERS)) {
                    if (!this.root.realm().canManageIdentityProviders()) {
                        return this.adminConflictMessage(role);
                    }
                    return true;
                }
                if (role.getName().equals(AdminRoles.VIEW_IDENTITY_PROVIDERS)) {
                    if (!this.root.realm().canViewIdentityProviders()) {
                        return this.adminConflictMessage(role);
                    }
                    return true;
                }
                if (role.getName().equals(AdminRoles.MANAGE_REALM)) {
                    if (!this.root.realm().canManageRealm()) {
                        return this.adminConflictMessage(role);
                    }
                    return true;
                }
                if (role.getName().equals(AdminRoles.VIEW_REALM)) {
                    if (!this.root.realm().canViewRealm()) {
                        return this.adminConflictMessage(role);
                    }
                    return true;
                }
                if (role.getName().equals(ImpersonationConstants.IMPERSONATION_ROLE)) {
                    if (!this.root.users().canImpersonate()) {
                        return this.adminConflictMessage(role);
                    }
                    return true;
                }
                if (role.getName().equals(AdminRoles.REALM_ADMIN)) {
                    if (this.root.adminsRealm() == null || !this.root.adminsRealm().getName().equals(Config.getAdminRealm())) {
                        return this.adminConflictMessage(role);
                    }
                    RealmModel masterRealm = this.root.adminsRealm();
                    RoleModel adminRole = masterRealm.getRole(AdminRoles.ADMIN);
                    if (this.root.admin().hasRole(adminRole)) {
                        return true;
                    }
                    return this.adminConflictMessage(role);
                }
                return this.adminConflictMessage(role);
            }
            if (role.getContainer() instanceof RealmModel ? (realm = (RealmModel)role.getContainer()).getName().equals(Config.getAdminRealm()) : (container = (ClientModel)role.getContainer()).getRealm().getName().equals(Config.getAdminRealm()) && container.getClientId().endsWith("-realm")) {
                return this.adminConflictMessage(role);
            }
            return true;
        }
        return true;
    }

    private boolean adminConflictMessage(RoleModel role) {
        logger.debug((Object)("Trying to assign admin privileges of role: " + role.getName() + " but admin doesn't have same privilege"));
        return false;
    }

    @Override
    public boolean canMapRole(RoleModel role) {
        Scope mapRoleScope;
        if (this.root.users().canManageDefault()) {
            return this.checkAdminRoles(role);
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        if (role.getContainer() instanceof ClientModel && this.root.clients().canMapRoles((ClientModel)role.getContainer())) {
            return true;
        }
        if (!this.isPermissionsEnabled(role)) {
            return false;
        }
        ResourceServer resourceServer = this.resourceServer(role);
        if (resourceServer == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(resourceServer, this.getMapRolePermissionName(role));
        if (policy == null || policy.getAssociatedPolicies().isEmpty()) {
            return false;
        }
        Resource roleResource = this.resource(role);
        if (this.root.evaluatePermission(roleResource, resourceServer, mapRoleScope = this.mapRoleScope(resourceServer))) {
            return this.checkAdminRoles(role);
        }
        return false;
    }

    @Override
    public void requireMapRole(RoleModel role) {
        if (!this.canMapRole(role)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canList(RoleContainerModel container) {
        if (this.canView(container)) {
            return true;
        }
        if (container instanceof RealmModel) {
            return this.root.realm().canViewRealm() || this.root.hasOneAdminRole(AdminRoles.ALL_QUERY_ROLES);
        }
        return this.root.clients().canList((ClientModel)container);
    }

    @Override
    public void requireList(RoleContainerModel container) {
        if (!this.canList(container)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManage(RoleContainerModel container) {
        if (container instanceof RealmModel) {
            return this.root.realm().canManageRealm();
        }
        return this.root.clients().canConfigure((ClientModel)container);
    }

    @Override
    public void requireManage(RoleContainerModel container) {
        if (!this.canManage(container)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView(RoleContainerModel container) {
        if (container instanceof RealmModel) {
            return this.root.realm().canViewRealm();
        }
        return this.root.clients().canView((ClientModel)container);
    }

    @Override
    public void requireView(RoleContainerModel container) {
        if (!this.canView(container)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canMapComposite(RoleModel role) {
        Scope scope;
        if (this.canManageDefault(role)) {
            return this.checkAdminRoles(role);
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        if (role.getContainer() instanceof ClientModel && this.root.clients().canMapCompositeRoles((ClientModel)role.getContainer())) {
            return true;
        }
        if (!this.isPermissionsEnabled(role)) {
            return false;
        }
        ResourceServer resourceServer = this.resourceServer(role);
        if (resourceServer == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(resourceServer, this.getMapCompositePermissionName(role));
        if (policy == null || policy.getAssociatedPolicies().isEmpty()) {
            return false;
        }
        Resource roleResource = this.resource(role);
        if (this.root.evaluatePermission(roleResource, resourceServer, scope = this.mapCompositeScope(resourceServer))) {
            return this.checkAdminRoles(role);
        }
        return false;
    }

    @Override
    public void requireMapComposite(RoleModel role) {
        if (!this.canMapComposite(role)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canMapClientScope(RoleModel role) {
        if (this.root.clients().canManageClientsDefault()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        if (role.getContainer() instanceof ClientModel && this.root.clients().canMapClientScopeRoles((ClientModel)role.getContainer())) {
            return true;
        }
        if (!this.isPermissionsEnabled(role)) {
            return false;
        }
        ResourceServer resourceServer = this.resourceServer(role);
        if (resourceServer == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(resourceServer, this.getMapClientScopePermissionName(role));
        if (policy == null || policy.getAssociatedPolicies().isEmpty()) {
            return false;
        }
        Resource roleResource = this.resource(role);
        Scope scope = this.mapClientScope(resourceServer);
        return this.root.evaluatePermission(roleResource, resourceServer, scope);
    }

    @Override
    public void requireMapClientScope(RoleModel role) {
        if (!this.canMapClientScope(role)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManage(RoleModel role) {
        if (role.getContainer() instanceof RealmModel) {
            return this.root.realm().canManageRealm();
        }
        if (role.getContainer() instanceof ClientModel) {
            ClientModel client = (ClientModel)role.getContainer();
            return this.root.clients().canConfigure(client);
        }
        return false;
    }

    public boolean canManageDefault(RoleModel role) {
        if (role.getContainer() instanceof RealmModel) {
            return this.root.realm().canManageRealmDefault();
        }
        if (role.getContainer() instanceof ClientModel) {
            ClientModel client = (ClientModel)role.getContainer();
            return this.root.clients().canManageClientsDefault();
        }
        return false;
    }

    @Override
    public void requireManage(RoleModel role) {
        if (!this.canManage(role)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView(RoleModel role) {
        if (role.getContainer() instanceof RealmModel) {
            return this.root.realm().canViewRealm();
        }
        if (role.getContainer() instanceof ClientModel) {
            ClientModel client = (ClientModel)role.getContainer();
            return this.root.clients().canView(client);
        }
        return false;
    }

    @Override
    public void requireView(RoleModel role) {
        if (!this.canView(role)) {
            throw new ForbiddenException();
        }
    }

    private ClientModel getRoleClient(RoleModel role) {
        ClientModel client = null;
        client = role.getContainer() instanceof ClientModel ? (ClientModel)role.getContainer() : this.root.getRealmManagementClient();
        return client;
    }

    @Override
    public Policy manageUsersPolicy(ResourceServer server) {
        RoleModel role = this.root.getRealmManagementClient().getRole(AdminRoles.MANAGE_USERS);
        return this.rolePolicy(server, role);
    }

    @Override
    public Policy viewUsersPolicy(ResourceServer server) {
        RoleModel role = this.root.getRealmManagementClient().getRole(AdminRoles.VIEW_USERS);
        return this.rolePolicy(server, role);
    }

    @Override
    public Policy rolePolicy(ResourceServer server, RoleModel role) {
        String policyName = Helper.getRolePolicyName(role);
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(server, policyName);
        if (policy != null) {
            return policy;
        }
        return Helper.createRolePolicy(this.authz, server, role, policyName);
    }

    @Override
    public Set<String> getRolesWithPermission(String scope) {
        if (!this.root.isAdminSameRealm()) {
            return Collections.emptySet();
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return Collections.emptySet();
        }
        HashSet<String> granted = new HashSet<String>();
        this.resourceStore.findByType(server, "Role", resource -> {
            if (this.hasPermission((Resource)resource, scope)) {
                granted.add(resource.getName().substring(RESOURCE_NAME_PREFIX.length()));
            }
        });
        return granted;
    }

    private boolean hasPermission(Resource resource, String scope) {
        ResourceServer server = this.root.realmResourceServer();
        Collection<Permission> permissions = this.root.evaluatePermission(new ResourcePermission(resource, (Collection)resource.getScopes(), server), server);
        for (Permission permission : permissions) {
            for (String s : permission.getScopes()) {
                if (!scope.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    private Scope mapRoleScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName(server, "map-role");
    }

    private Scope mapClientScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName(server, "map-role-client-scope");
    }

    private Scope mapCompositeScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName(server, "map-role-composite");
    }

    private void initialize(RoleModel role) {
        Policy mapCompositePermission;
        Policy mapClientScopePermission;
        Policy mapRolePermission;
        Scope mapCompositeScope;
        Scope mapClientScope;
        ClientModel client;
        ResourceServer server = this.resourceServer(role);
        if (server == null && (server = this.root.findOrCreateResourceServer(client = this.getRoleClient(role))) == null) {
            return;
        }
        Scope mapRoleScope = this.mapRoleScope(server);
        if (mapRoleScope == null) {
            mapRoleScope = this.authz.getStoreFactory().getScopeStore().create(server, "map-role");
        }
        if ((mapClientScope = this.mapClientScope(server)) == null) {
            mapClientScope = this.authz.getStoreFactory().getScopeStore().create(server, "map-role-client-scope");
        }
        if ((mapCompositeScope = this.mapCompositeScope(server)) == null) {
            mapCompositeScope = this.authz.getStoreFactory().getScopeStore().create(server, "map-role-composite");
        }
        String roleResourceName = RolePermissions.getRoleResourceName(role);
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(server, roleResourceName);
        if (resource == null) {
            resource = this.authz.getStoreFactory().getResourceStore().create(server, roleResourceName, server.getClientId());
            HashSet<Scope> scopeset = new HashSet<Scope>();
            scopeset.add(mapClientScope);
            scopeset.add(mapCompositeScope);
            scopeset.add(mapRoleScope);
            resource.updateScopes(scopeset);
            resource.setType("Role");
        }
        if ((mapRolePermission = this.mapRolePermission(role)) == null) {
            mapRolePermission = Helper.addEmptyScopePermission(this.authz, server, this.getMapRolePermissionName(role), resource, mapRoleScope);
            mapRolePermission.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        }
        if ((mapClientScopePermission = this.mapClientScopePermission(role)) == null) {
            mapClientScopePermission = Helper.addEmptyScopePermission(this.authz, server, this.getMapClientScopePermissionName(role), resource, mapClientScope);
            mapClientScopePermission.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        }
        if ((mapCompositePermission = this.mapCompositePermission(role)) == null) {
            mapCompositePermission = Helper.addEmptyScopePermission(this.authz, server, this.getMapCompositePermissionName(role), resource, mapCompositeScope);
            mapCompositePermission.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        }
    }

    private String getMapRolePermissionName(RoleModel role) {
        return "map-role.permission." + role.getId();
    }

    private String getMapClientScopePermissionName(RoleModel role) {
        return "map-role-client-scope.permission." + role.getId();
    }

    private String getMapCompositePermissionName(RoleModel role) {
        return "map-role-composite.permission." + role.getId();
    }

    private static String getRoleResourceName(RoleModel role) {
        return RESOURCE_NAME_PREFIX + role.getId();
    }
}

