/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AuthDetails;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.util.JsonSerialization;

public class AdminEventBuilder {
    protected static final Logger logger = Logger.getLogger(AdminEventBuilder.class);
    private final AdminAuth auth;
    private final String ipAddress;
    private final RealmModel realm;
    private final AdminEvent adminEvent;
    private final Map<String, EventListenerProvider> listeners;
    private final KeycloakSession session;
    private EventStoreProvider store;

    public AdminEventBuilder(RealmModel realm, AdminAuth auth, KeycloakSession session, ClientConnection clientConnection) {
        this(realm, auth, session, clientConnection.getRemoteAddr(), null);
    }

    private AdminEventBuilder(RealmModel realm, AdminAuth auth, KeycloakSession session, String ipAddress, AdminEvent adminEvent) {
        this.realm = realm;
        this.listeners = new HashMap<String, EventListenerProvider>();
        this.updateStore(session);
        this.addListeners(session);
        this.auth = auth;
        this.ipAddress = ipAddress;
        if (adminEvent != null) {
            this.adminEvent = new AdminEvent(adminEvent);
        } else {
            this.adminEvent = new AdminEvent();
            this.realm(realm);
            this.authRealm(auth.getRealm());
            this.authClient(auth.getClient());
            this.authUser(auth.getUser());
            this.authIpAddress(ipAddress);
        }
        this.session = session;
    }

    public AdminEventBuilder clone(KeycloakSession session) {
        RealmModel newEventRealm = session.realms().getRealm(this.realm.getId());
        RealmModel newAuthRealm = session.realms().getRealm(this.auth.getRealm().getId());
        UserModel newAuthUser = session.users().getUserById(newAuthRealm, this.auth.getUser().getId());
        ClientModel newAuthClient = session.clients().getClientById(newAuthRealm, this.auth.getClient().getId());
        return new AdminEventBuilder(newEventRealm, new AdminAuth(newAuthRealm, this.auth.getToken(), newAuthUser, newAuthClient), session, this.ipAddress, this.adminEvent);
    }

    public AdminEventBuilder realm(RealmModel realm) {
        this.adminEvent.setRealmId(realm.getId());
        this.adminEvent.setRealmName(realm.getName());
        return this;
    }

    public AdminEventBuilder refreshRealmEventsConfig(KeycloakSession session) {
        return this.updateStore(session).addListeners(session);
    }

    private AdminEventBuilder updateStore(KeycloakSession session) {
        if (this.realm.isAdminEventsEnabled() && this.store == null) {
            this.store = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
            if (this.store == null) {
                ServicesLogger.LOGGER.noEventStoreProvider();
            }
        }
        return this;
    }

    private AdminEventBuilder addListeners(KeycloakSession session) {
        this.realm.getEventsListenersStream().filter(((Predicate<String>)this.listeners::containsKey).negate()).forEach(id -> {
            EventListenerProvider listener = (EventListenerProvider)session.getProvider(EventListenerProvider.class, id);
            if (listener != null) {
                this.listeners.put((String)id, listener);
            } else {
                ServicesLogger.LOGGER.providerNotFound((String)id);
            }
        });
        return this;
    }

    public AdminEventBuilder operation(OperationType operationType) {
        this.adminEvent.setOperationType(operationType);
        return this;
    }

    public AdminEventBuilder resource(ResourceType resourceType) {
        this.adminEvent.setResourceType(resourceType);
        return this;
    }

    public AdminEventBuilder resource(String resourceType) {
        this.adminEvent.setResourceTypeAsString(resourceType);
        return this;
    }

    public AdminEventBuilder authRealm(RealmModel realm) {
        AuthDetails authDetails = this.adminEvent.getAuthDetails();
        if (authDetails == null) {
            authDetails = new AuthDetails();
            authDetails.setRealmId(realm.getId());
        } else {
            authDetails.setRealmId(realm.getId());
        }
        authDetails.setRealmName(realm.getName());
        this.adminEvent.setAuthDetails(authDetails);
        return this;
    }

    public AdminEventBuilder authClient(ClientModel client) {
        AuthDetails authDetails = this.adminEvent.getAuthDetails();
        if (authDetails == null) {
            authDetails = new AuthDetails();
            authDetails.setClientId(client.getId());
        } else {
            authDetails.setClientId(client.getId());
        }
        this.adminEvent.setAuthDetails(authDetails);
        return this;
    }

    public AdminEventBuilder authUser(UserModel user) {
        AuthDetails authDetails = this.adminEvent.getAuthDetails();
        if (authDetails == null) {
            authDetails = new AuthDetails();
            authDetails.setUserId(user.getId());
        } else {
            authDetails.setUserId(user.getId());
        }
        this.adminEvent.setAuthDetails(authDetails);
        return this;
    }

    public AdminEventBuilder authIpAddress(String ipAddress) {
        AuthDetails authDetails = this.adminEvent.getAuthDetails();
        if (authDetails == null) {
            authDetails = new AuthDetails();
            authDetails.setIpAddress(ipAddress);
        } else {
            authDetails.setIpAddress(ipAddress);
        }
        this.adminEvent.setAuthDetails(authDetails);
        return this;
    }

    public AdminEventBuilder resourcePath(String ... pathElements) {
        StringBuilder sb = new StringBuilder();
        for (String element : pathElements) {
            sb.append("/");
            sb.append(element);
        }
        if (pathElements.length > 0) {
            sb.deleteCharAt(0);
        }
        this.adminEvent.setResourcePath(sb.toString());
        return this;
    }

    public AdminEventBuilder resourcePath(UriInfo uriInfo) {
        String path = this.getResourcePath(uriInfo);
        this.adminEvent.setResourcePath(path);
        return this;
    }

    public AdminEventBuilder resourcePath(UriInfo uriInfo, String id) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getResourcePath(uriInfo));
        sb.append("/");
        sb.append(id);
        this.adminEvent.setResourcePath(sb.toString());
        return this;
    }

    private String getResourcePath(UriInfo uriInfo) {
        String path = uriInfo.getPath();
        StringBuilder sb = new StringBuilder();
        sb.append("/realms/");
        sb.append(this.realm.getName());
        sb.append("/");
        String realmRelative = sb.toString();
        return path.substring(path.indexOf(realmRelative) + realmRelative.length());
    }

    public AdminEventBuilder representation(Object value) {
        if (value == null || value.equals("")) {
            return this;
        }
        StripSecretsUtils.stripSecrets((KeycloakSession)this.session, (Object)value);
        try {
            this.adminEvent.setRepresentation(JsonSerialization.writeValueAsString((Object)value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public AdminEvent getEvent() {
        return this.adminEvent;
    }

    public void success() {
        this.send();
    }

    private void send() {
        boolean includeRepresentation = this.realm.isAdminEventsDetailsEnabled();
        AdminEvent eventCopy = new AdminEvent(this.adminEvent);
        eventCopy.setTime(Time.currentTimeMillis());
        eventCopy.setId(UUID.randomUUID().toString());
        if (this.store != null) {
            this.store.onEvent(eventCopy, includeRepresentation);
        }
        if (this.listeners != null) {
            for (EventListenerProvider l : this.listeners.values()) {
                try {
                    l.onEvent(eventCopy, includeRepresentation);
                }
                catch (Throwable t) {
                    ServicesLogger.LOGGER.failedToSendType(t, l);
                }
            }
        }
    }
}

