/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.x509;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

public abstract class AbstractX509ClientCertificateAuthenticatorFactory
implements AuthenticatorFactory {
    private static final String[] mappingSources = new String[]{"Match SubjectDN using regular expression", "Subject's e-mail", "Subject's Alternative Name E-mail", "Subject's Alternative Name otherName (UPN)", "Subject's Common Name", "Match IssuerDN using regular expression", "Certificate Serial Number", "Certificate Serial Number and IssuerDN", "SHA-256 Thumbprint", "Full Certificate in PEM format"};
    private static final String[] userModelMappers = new String[]{"Custom Attribute Mapper", "Username or Email"};
    private static final String[] CERTIFICATE_POLICY_MODES = new String[]{"All", "Any"};
    protected static final List<ProviderConfigProperty> configProperties;

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    static {
        LinkedList mappingSourceTypes = new LinkedList();
        Collections.addAll(mappingSourceTypes, mappingSources);
        ProviderConfigProperty mappingMethodList = new ProviderConfigProperty();
        mappingMethodList.setType("List");
        mappingMethodList.setName("x509-cert-auth.mapping-source-selection");
        mappingMethodList.setLabel("User Identity Source");
        mappingMethodList.setHelpText("Choose how to extract user identity from X509 certificate or the certificate fields. For example, SubjectDN will match the custom regular expression specified below to the value of certificate's SubjectDN field.");
        mappingMethodList.setDefaultValue((Object)mappingSources[0]);
        mappingMethodList.setOptions(mappingSourceTypes);
        ProviderConfigProperty canonicalDn = new ProviderConfigProperty();
        canonicalDn.setType("boolean");
        canonicalDn.setName("x509-cert-auth.canonical-dn-enabled");
        canonicalDn.setLabel("Canonical DN representation enabled");
        canonicalDn.setDefaultValue((Object)Boolean.toString(false));
        canonicalDn.setHelpText("Use the canonical format to determine the distinguished name. This option is relevant for authenticators using a distinguished name.");
        ProviderConfigProperty serialnumberHex = new ProviderConfigProperty();
        serialnumberHex.setType("boolean");
        serialnumberHex.setName("x509-cert-auth.serialnumber-hex-enabled");
        serialnumberHex.setLabel("Enable Serial Number hexadecimal representation");
        serialnumberHex.setDefaultValue((Object)Boolean.toString(false));
        serialnumberHex.setHelpText("Use the hex representation of the serial number. This option is relevant for authenticators using serial number.");
        ProviderConfigProperty regExp = new ProviderConfigProperty();
        regExp.setType("String");
        regExp.setName("x509-cert-auth.regular-expression");
        regExp.setLabel("A regular expression to extract user identity");
        regExp.setDefaultValue((Object)"(.*?)(?:$)");
        regExp.setHelpText("The regular expression to extract a user identity. The expression must contain a single group. For example, 'uniqueId=(.*?)(?:,|$)' will match 'uniqueId=somebody@company.org, CN=somebody' and give somebody@company.org");
        LinkedList mapperTypes = new LinkedList();
        Collections.addAll(mapperTypes, userModelMappers);
        ProviderConfigProperty userMapperList = new ProviderConfigProperty();
        userMapperList.setType("List");
        userMapperList.setName("x509-cert-auth.mapper-selection");
        userMapperList.setHelpText("Choose how to map extracted user identities to users");
        userMapperList.setLabel("User mapping method");
        userMapperList.setDefaultValue((Object)userModelMappers[0]);
        userMapperList.setOptions(mapperTypes);
        ProviderConfigProperty attributeOrPropertyValue = new ProviderConfigProperty();
        attributeOrPropertyValue.setType("MultivaluedString");
        attributeOrPropertyValue.setName("x509-cert-auth.mapper-selection.user-attribute-name");
        attributeOrPropertyValue.setDefaultValue((Object)"usercertificate");
        attributeOrPropertyValue.setLabel("A name of user attribute");
        attributeOrPropertyValue.setHelpText("A name of user attribute to map the extracted user identity to existing user. The name must be a valid, existing user attribute if User Mapping Method is set to Custom Attribute Mapper. Multiple values are relevant when attribute mapping is related to multiple values, e.g. 'Certificate Serial Number and IssuerDN'");
        ProviderConfigProperty timestampValidationValue = new ProviderConfigProperty();
        timestampValidationValue.setType("boolean");
        timestampValidationValue.setName("x509-cert-auth.timestamp-validation-enabled");
        timestampValidationValue.setLabel("Check certificate validity");
        timestampValidationValue.setDefaultValue((Object)Boolean.toString(true));
        timestampValidationValue.setHelpText("Will verify that the certificate has not expired yet and is already valid by checking the attributes 'notBefore' and 'notAfter'.");
        ProviderConfigProperty crlCheckingEnabled = new ProviderConfigProperty();
        crlCheckingEnabled.setType("boolean");
        crlCheckingEnabled.setName("x509-cert-auth.crl-checking-enabled");
        crlCheckingEnabled.setHelpText("Enable Certificate Revocation Checking using CRL");
        crlCheckingEnabled.setLabel("CRL Checking Enabled");
        ProviderConfigProperty crlDPEnabled = new ProviderConfigProperty();
        crlDPEnabled.setType("boolean");
        crlDPEnabled.setName("x509-cert-auth.crldp-checking-enabled");
        crlDPEnabled.setDefaultValue((Object)Boolean.toString(false));
        crlDPEnabled.setLabel("Enable CRL Distribution Point to check certificate revocation status");
        crlDPEnabled.setHelpText("CRL Distribution Point is a starting point for CRL. If this is ON, then CRL checking will be done based on the CRL distribution points included in the checked certificates. CDP is optional, but most PKI authorities include CDP in their certificates.");
        ProviderConfigProperty cRLRelativePath = new ProviderConfigProperty();
        cRLRelativePath.setType("MultivaluedString");
        cRLRelativePath.setName("x509-cert-auth.crl-relative-path");
        cRLRelativePath.setDefaultValue((Object)"crl.pem");
        cRLRelativePath.setLabel("CRL Path");
        cRLRelativePath.setHelpText("Applied just if CRL checking is ON and CRL Distribution point is OFF. It contains the URL (typically 'http' or 'ldap') where the CRL is available. Alternatively it can contain the path to a CRL file that contains a list of revoked certificates. Paths are assumed to be relative to $jboss.server.config.dir. Multiple CRLs can be included, however it can affect performance as the certificate will be checked against all listed CRLs.");
        ProviderConfigProperty oCspCheckingEnabled = new ProviderConfigProperty();
        oCspCheckingEnabled.setType("boolean");
        oCspCheckingEnabled.setName("x509-cert-auth.ocsp-checking-enabled");
        oCspCheckingEnabled.setHelpText("Enable Certificate Revocation Checking using OCSP");
        oCspCheckingEnabled.setLabel("OCSP Checking Enabled");
        ProviderConfigProperty ocspFailOpen = new ProviderConfigProperty();
        ocspFailOpen.setType("boolean");
        ocspFailOpen.setName("x509-cert-auth.ocsp-fail-open");
        ocspFailOpen.setDefaultValue((Object)Boolean.toString(false));
        ocspFailOpen.setHelpText("Whether to allow or deny authentication for client certificates that have missing/invalid/inconclusive OCSP endpoints. By default a successful OCSP response is required.");
        ocspFailOpen.setLabel("OCSP Fail-Open Behavior");
        ProviderConfigProperty ocspResponderUri = new ProviderConfigProperty();
        ocspResponderUri.setType("String");
        ocspResponderUri.setName("x509-cert-auth.ocsp-responder-uri");
        ocspResponderUri.setLabel("OCSP Responder Uri");
        ocspResponderUri.setHelpText("Clients use OCSP Responder Uri to check certificate revocation status.");
        ProviderConfigProperty ocspResponderCert = new ProviderConfigProperty();
        ocspResponderCert.setType("Text");
        ocspResponderCert.setName("x509-cert-auth.ocsp-responder-certificate");
        ocspResponderCert.setLabel("OCSP Responder Certificate");
        ocspResponderCert.setHelpText("Optional certificate used by the responder to sign the responses. The certificate should be in PEM format without BEGIN and END tags. It is only used if the OCSP Responder URI is set. By default, the certificate of the OCSP responder is that of the issuer of the certificate being validated or one with the OCSPSigning extension and also issued by the same CA. This option identifies the certificate of the OCSP responder when the defaults do not apply.");
        ProviderConfigProperty keyUsage = new ProviderConfigProperty();
        keyUsage.setType("String");
        keyUsage.setName("x509-cert-auth.keyusage");
        keyUsage.setLabel("Validate Key Usage");
        keyUsage.setHelpText("Validates that the purpose of the key contained in the certificate (encipherment, signature, etc.) matches its intended purpose. Leaving the field blank will disable Key Usage validation. For example, 'digitalSignature, keyEncipherment' will check if the digitalSignature and keyEncipherment bits (bit 0 and bit 2 respectively) are set in certificate's X509 Key Usage extension. See RFC 5280 for a detailed definition of X509 Key Usage extension.");
        ProviderConfigProperty extendedKeyUsage = new ProviderConfigProperty();
        extendedKeyUsage.setType("String");
        extendedKeyUsage.setName("x509-cert-auth.extendedkeyusage");
        extendedKeyUsage.setLabel("Validate Extended Key Usage");
        extendedKeyUsage.setHelpText("Validates the extended purposes of the certificate's key using certificate's Extended Key Usage extension. Leaving the field blank will disable Extended Key Usage validation. See RFC 5280 for a detailed definition of X509 Extended Key Usage extension.");
        ProviderConfigProperty certificatePolicy = new ProviderConfigProperty();
        certificatePolicy.setType("String");
        certificatePolicy.setName("x509-cert-auth.certificate-policy");
        certificatePolicy.setLabel("Validate Certificate Policy");
        certificatePolicy.setHelpText("Validates the certificate policies of the certificate's key using certificate's Policy extension. Leaving the field blank will disable Certificate Policies validation. Multiple policies should be separated using a comma. See RFC 5280 for a detailed definition of X509 Certificate Policy extension.");
        LinkedList certificatePolicyModesOptions = new LinkedList();
        Collections.addAll(certificatePolicyModesOptions, CERTIFICATE_POLICY_MODES);
        ProviderConfigProperty certificatePolicyMode = new ProviderConfigProperty();
        certificatePolicyMode.setType("List");
        certificatePolicyMode.setName("x509-cert-auth.certificate-policy-mode");
        certificatePolicyMode.setLabel("Certificate Policy Validation Mode");
        certificatePolicyMode.setHelpText("If Certificate Policy validation is specified, indicates whether it should match all or at least one of the specified policies.");
        certificatePolicyMode.setDefaultValue((Object)CERTIFICATE_POLICY_MODES[0]);
        certificatePolicyMode.setOptions(certificatePolicyModesOptions);
        ProviderConfigProperty identityConfirmationPageDisallowed = new ProviderConfigProperty();
        identityConfirmationPageDisallowed.setType("boolean");
        identityConfirmationPageDisallowed.setName("x509-cert-auth.confirmation-page-disallowed");
        identityConfirmationPageDisallowed.setLabel("Bypass identity confirmation");
        identityConfirmationPageDisallowed.setHelpText("By default, the users are prompted to confirm their identity extracted from X509 client certificate. The identity confirmation prompt is skipped if the option is switched on.");
        ProviderConfigProperty revalidateCertificateEnabled = new ProviderConfigProperty();
        revalidateCertificateEnabled.setType("boolean");
        revalidateCertificateEnabled.setName("x509-cert-auth.revalidate-certificate-enabled");
        revalidateCertificateEnabled.setLabel("Revalidate Client Certificate");
        revalidateCertificateEnabled.setHelpText("Forces revalidation of the client certificate according to the certificates defined in the truststore. This is useful when behind a non-validating proxy or when the number of allowed certificate chains would be too large for mutual SSL negotiation.");
        configProperties = Arrays.asList(mappingMethodList, canonicalDn, serialnumberHex, regExp, userMapperList, attributeOrPropertyValue, timestampValidationValue, crlCheckingEnabled, crlDPEnabled, cRLRelativePath, oCspCheckingEnabled, ocspFailOpen, ocspResponderUri, ocspResponderCert, keyUsage, extendedKeyUsage, identityConfirmationPageDisallowed, revalidateCertificateEnabled, certificatePolicy, certificatePolicyMode);
    }
}

