/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clienttype.client;

import java.util.Objects;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.keycloak.client.clienttype.ClientType;
import org.keycloak.client.clienttype.ClientTypeException;
import org.keycloak.common.util.ObjectUtil;

interface TypedClientAttribute {
    public static final Logger logger = Logger.getLogger(TypedClientAttribute.class);

    default public <T> T getClientAttribute(ClientType clientType, Class<T> tClass) {
        String propertyName = this.getPropertyName();
        Object nonApplicableValue = this.getNonApplicableValue();
        if (!clientType.isApplicable(propertyName)) {
            try {
                return tClass.cast(nonApplicableValue);
            }
            catch (ClassCastException e) {
                logger.error("Could not apply client type property %s: %s", (Object)propertyName, (Throwable)e);
                throw e;
            }
        }
        return (T)clientType.getTypeValue(propertyName, tClass);
    }

    default public <T> void setClientAttribute(ClientType clientType, T newValue, Consumer<T> clientSetter, Class<T> tClass) {
        String propertyName = this.getPropertyName();
        if (!clientType.isApplicable(propertyName)) {
            if (!Objects.equals(this.getNonApplicableValue(), newValue)) {
                logger.warnf("Property %s is not-applicable to client type %s and can not be modified.", (Object)propertyName, (Object)clientType.getName());
            }
            return;
        }
        Object oldVal = clientType.getTypeValue(propertyName, tClass);
        if (!ObjectUtil.isEqualOrBothNull((Object)oldVal, newValue)) {
            throw ClientTypeException.Message.CLIENT_UPDATE_FAILED_CLIENT_TYPE_VALIDATION.exception(new Object[]{propertyName});
        }
        clientSetter.accept(newValue);
    }

    public String getPropertyName();

    public Object getNonApplicableValue();
}

