/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyStatus;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.AbstractEcdsaKeyProviderFactory;
import org.keycloak.keys.JavaKeystoreKeyProviderFactory;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.RealmModel;

public class JavaKeystoreKeyProvider
implements KeyProvider {
    private final KeyStatus status;
    private final ComponentModel model;
    private final KeyWrapper key;
    private final String algorithm;

    public JavaKeystoreKeyProvider(RealmModel realm, ComponentModel model) {
        this.model = model;
        this.status = KeyStatus.from((boolean)model.get("active", true), (boolean)model.get("enabled", true));
        String defaultAlgorithmKey = KeyUse.ENC.name().equals(model.get("keyUse")) ? "RSA-OAEP" : "RS256";
        this.algorithm = model.get("algorithm", defaultAlgorithmKey);
        if (model.hasNote(KeyWrapper.class.getName())) {
            this.key = (KeyWrapper)model.getNote(KeyWrapper.class.getName());
        } else {
            this.key = this.loadKey(realm, model);
            model.setNote(KeyWrapper.class.getName(), (Object)this.key);
        }
    }

    protected KeyWrapper loadKey(RealmModel realm, ComponentModel model) {
        String string;
        String keystorePath = model.get(JavaKeystoreKeyProviderFactory.KEYSTORE_KEY);
        FileInputStream is = new FileInputStream(keystorePath);
        try {
            KeyStore keyStore = this.loadKeyStore(is, keystorePath);
            String keyAlias = model.get(JavaKeystoreKeyProviderFactory.KEY_ALIAS_KEY);
            string = switch (this.algorithm) {
                case "PS256", "PS384", "PS512", "RS256", "RS384", "RS512", "RSA-OAEP", "RSA1_5", "RSA-OAEP-256" -> this.loadRSAKey(realm, model, keyStore, keyAlias);
                case "ES256", "ES384", "ES512" -> this.loadECKey(realm, model, keyStore, keyAlias);
                default -> throw new RuntimeException(String.format("Keys for algorithm %s are not supported.", this.algorithm));
            };
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (KeyStoreException kse) {
                throw new RuntimeException("KeyStore error on server. " + kse.getMessage(), kse);
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException("File not found on server. " + fnfe.getMessage(), fnfe);
            }
            catch (IOException ioe) {
                throw new RuntimeException("IO error on server. " + ioe.getMessage(), ioe);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("Algorithm not available on server. " + nsae.getMessage(), nsae);
            }
            catch (CertificateException ce) {
                throw new RuntimeException("Certificate error on server. " + ce.getMessage(), ce);
            }
            catch (UnrecoverableKeyException uke) {
                throw new RuntimeException("Keystore on server can not be recovered. " + uke.getMessage(), uke);
            }
            catch (GeneralSecurityException gse) {
                throw new RuntimeException("Invalid certificate chain. Check the order of certificates.", gse);
            }
        }
        is.close();
        return string;
    }

    private KeyStore loadKeyStore(FileInputStream inputStream, String keystorePath) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        String keystoreType = KeystoreUtil.getKeystoreType((String)this.model.get(JavaKeystoreKeyProviderFactory.KEYSTORE_TYPE_KEY), (String)keystorePath, (String)"JKS");
        KeyStore keyStore = KeyStore.getInstance(keystoreType);
        keyStore.load(inputStream, this.model.get(JavaKeystoreKeyProviderFactory.KEYSTORE_PASSWORD_KEY).toCharArray());
        return keyStore;
    }

    private KeyWrapper loadECKey(RealmModel realm, ComponentModel model, KeyStore keyStore, String keyAlias) throws GeneralSecurityException {
        ECPrivateKey privateKey = (ECPrivateKey)keyStore.getKey(keyAlias, model.get(JavaKeystoreKeyProviderFactory.KEY_PASSWORD_KEY).toCharArray());
        String curve = AbstractEcdsaKeyProviderFactory.convertECDomainParmNistRepToSecRep(AbstractEcdsaKeyProviderFactory.convertAlgorithmToECDomainParmNistRep(this.algorithm));
        ECPublicKey publicKey = CryptoIntegration.getProvider().getEcdsaCryptoProvider().getPublicFromPrivate(privateKey);
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        return this.createKeyWrapper(keyPair, this.getCertificate(keyStore, keyPair, keyAlias, realm.getName()), this.loadCertificateChain(keyStore, keyAlias), "EC");
    }

    private X509Certificate getCertificate(KeyStore keyStore, KeyPair keyPair, String keyAlias, String realmName) throws KeyStoreException {
        X509Certificate certificate = (X509Certificate)keyStore.getCertificate(keyAlias);
        if (certificate == null) {
            certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)realmName);
        }
        return certificate;
    }

    private KeyWrapper loadRSAKey(RealmModel realm, ComponentModel model, KeyStore keyStore, String keyAlias) throws GeneralSecurityException {
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, model.get(JavaKeystoreKeyProviderFactory.KEY_PASSWORD_KEY).toCharArray());
        PublicKey publicKey = KeyUtils.extractPublicKey((PrivateKey)privateKey);
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        return this.createKeyWrapper(keyPair, this.getCertificate(keyStore, keyPair, keyAlias, realm.getName()), this.loadCertificateChain(keyStore, keyAlias), "RSA");
    }

    private List<X509Certificate> loadCertificateChain(KeyStore keyStore, String keyAlias) throws GeneralSecurityException {
        List chain = Optional.ofNullable(keyStore.getCertificateChain(keyAlias)).map(certificates -> Arrays.stream(certificates).map(X509Certificate.class::cast).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        this.validateCertificateChain(chain);
        return chain;
    }

    private KeyWrapper createKeyWrapper(KeyPair keyPair, X509Certificate certificate, List<X509Certificate> certificateChain, String type) {
        KeyUse keyUse = KeyUse.valueOf((String)this.model.get("keyUse", KeyUse.SIG.getSpecName()).toUpperCase());
        KeyWrapper key = new KeyWrapper();
        key.setProviderId(this.model.getId());
        key.setProviderPriority(this.model.get("priority", 0L));
        key.setKid(this.model.get("kid") != null ? this.model.get("kid") : KeyUtils.createKeyId((Key)keyPair.getPublic()));
        key.setUse(keyUse);
        key.setType(type);
        key.setAlgorithm(this.algorithm);
        key.setStatus(this.status);
        key.setPrivateKey((Key)keyPair.getPrivate());
        key.setPublicKey((Key)keyPair.getPublic());
        key.setCertificate(certificate);
        if (!certificateChain.isEmpty()) {
            if (certificate != null && !certificate.equals(certificateChain.get(0))) {
                certificateChain.add(0, certificate);
            }
            key.setCertificateChain(certificateChain);
        }
        return key;
    }

    private void validateCertificateChain(List<X509Certificate> certificates) throws GeneralSecurityException {
        if (certificates == null || certificates.isEmpty()) {
            return;
        }
        HashSet<TrustAnchor> anchors = new HashSet<TrustAnchor>();
        anchors.add(new TrustAnchor(certificates.get(certificates.size() - 1), null));
        PKIXParameters params = new PKIXParameters(anchors);
        params.setRevocationEnabled(false);
        CertPath certPath = CertificateFactory.getInstance("X.509").generateCertPath(certificates);
        CertPathValidator validator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
        validator.validate(certPath, params);
    }

    public Stream<KeyWrapper> getKeysStream() {
        return Stream.of(this.key);
    }
}

