/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.context.AdminClientRegisterContext;
import org.keycloak.services.clientpolicy.context.AdminClientUpdateContext;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.context.DynamicClientRegisterContext;
import org.keycloak.services.clientpolicy.context.DynamicClientUpdateContext;

public class ClientUpdaterSourceRolesCondition
extends AbstractClientPolicyConditionProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(ClientUpdaterSourceRolesCondition.class);

    public ClientUpdaterSourceRolesCondition(KeycloakSession session) {
        super(session);
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "client-updater-source-roles";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: {
                if (context instanceof AdminClientRegisterContext) {
                    return this.getVoteForRolesMatched(((ClientCRUDContext)context).getAuthenticatedUser());
                }
                if (context instanceof DynamicClientRegisterContext) {
                    return this.getVoteForRolesMatched(((ClientCRUDContext)context).getToken());
                }
                throw new ClientPolicyException("server_error", "unexpected context type.");
            }
            case UPDATE: {
                if (context instanceof AdminClientUpdateContext) {
                    return this.getVoteForRolesMatched(((ClientCRUDContext)context).getAuthenticatedUser());
                }
                if (context instanceof DynamicClientUpdateContext) {
                    return this.getVoteForRolesMatched(((ClientCRUDContext)context).getToken());
                }
                throw new ClientPolicyException("server_error", "unexpected context type.");
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private ClientPolicyVote getVoteForRolesMatched(UserModel user) {
        if (this.isRolesMatched(user)) {
            return ClientPolicyVote.YES;
        }
        return ClientPolicyVote.NO;
    }

    private ClientPolicyVote getVoteForRolesMatched(JsonWebToken token) {
        if (token == null) {
            return ClientPolicyVote.NO;
        }
        if (this.isRoleMatched(token.getSubject())) {
            return ClientPolicyVote.YES;
        }
        return ClientPolicyVote.NO;
    }

    private boolean isRoleMatched(String subjectId) {
        if (subjectId == null) {
            return false;
        }
        return this.isRolesMatched(this.session.users().getUserById(this.session.getContext().getRealm(), subjectId));
    }

    private boolean isRolesMatched(UserModel user) {
        if (user == null) {
            return false;
        }
        Set<String> expectedRoles = this.instantiateRolesForMatching();
        if (expectedRoles == null) {
            return false;
        }
        if (logger.isTraceEnabled()) {
            Set<String> roles = user.getRoleMappingsStream().map(RoleModel::getName).collect(Collectors.toSet());
            roles.forEach(i -> logger.tracev("user role = {0}", i));
            expectedRoles.forEach(i -> logger.tracev("roles expected = {0}", i));
        }
        RealmModel realm = this.session.getContext().getRealm();
        for (String roleName : expectedRoles) {
            RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)roleName);
            if (role == null || !user.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    private Set<String> instantiateRolesForMatching() {
        List<String> roles = ((Configuration)this.configuration).getRoles();
        if (roles == null) {
            return null;
        }
        return new HashSet<String>(roles);
    }

    public static class Configuration
    extends ClientPolicyConditionConfigurationRepresentation {
        protected List<String> roles;

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }
    }
}

