/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.endpoints;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.CibaConfig;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuth2DeviceCodeModel;
import org.keycloak.models.OAuth2DeviceUserCodeModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelProvider;
import org.keycloak.protocol.oidc.grants.ciba.channel.CIBAAuthenticationRequest;
import org.keycloak.protocol.oidc.grants.ciba.clientpolicy.context.BackchannelAuthenticationRequestContext;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.AbstractCibaEndpoint;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.request.BackchannelAuthenticationEndpointRequest;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.request.BackchannelAuthenticationEndpointRequestParserProcessor;
import org.keycloak.protocol.oidc.grants.ciba.resolvers.CIBALoginUserResolver;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.util.JsonSerialization;

public class BackchannelAuthenticationEndpoint
extends AbstractCibaEndpoint {
    private static final Logger log = Logger.getLogger(BackchannelAuthenticationEndpoint.class);
    private final RealmModel realm;
    private static final Pattern BINDING_MESSAGE_VALIDATION = Pattern.compile("^[a-zA-Z0-9-._+/!?#]{1,50}$");

    public BackchannelAuthenticationEndpoint(KeycloakSession session, EventBuilder event) {
        super(session, event);
        this.realm = session.getContext().getRealm();
        event.event(EventType.LOGIN);
    }

    @POST
    @NoCache
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response processGrantRequest() {
        HttpRequest httpRequest = this.session.getContext().getHttpRequest();
        CIBAAuthenticationRequest request = this.authorizeClient((MultivaluedMap<String, String>)httpRequest.getDecodedFormParameters());
        try {
            String authReqId = request.serialize(this.session);
            AuthenticationChannelProvider provider = (AuthenticationChannelProvider)this.session.getProvider(AuthenticationChannelProvider.class);
            if (provider == null) {
                throw new RuntimeException("Authentication Channel Provider not found.");
            }
            CIBALoginUserResolver resolver = (CIBALoginUserResolver)this.session.getProvider(CIBALoginUserResolver.class);
            if (resolver == null) {
                throw new RuntimeException("CIBA Login User Resolver not setup properly.");
            }
            UserModel user = request.getUser();
            String infoUsedByAuthentication = resolver.getInfoUsedByAuthentication(user);
            if (provider.requestAuthentication(request, infoUsedByAuthentication)) {
                CibaConfig cibaPolicy = this.realm.getCibaPolicy();
                int poolingInterval = cibaPolicy.getPoolingInterval();
                this.storeAuthenticationRequest(request, cibaPolicy, authReqId);
                ObjectNode response = JsonSerialization.createObjectNode();
                response.put("auth_req_id", authReqId).put("expires_in", cibaPolicy.getExpiresIn());
                if (poolingInterval > 0) {
                    response.put("interval", poolingInterval);
                }
                return Response.ok((Object)JsonSerialization.writeValueAsBytes((Object)response)).build();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unexpected failure when processing CIBA authentication request", (Throwable)e);
            throw new ErrorResponseException("server_error", "Failed to send authentication request", Response.Status.SERVICE_UNAVAILABLE);
        }
        throw new ErrorResponseException("server_error", "Unexpected response from authentication device", Response.Status.SERVICE_UNAVAILABLE);
    }

    private void storeAuthenticationRequest(CIBAAuthenticationRequest request, CibaConfig cibaConfig, String authReqId) {
        ClientModel client = request.getClient();
        int expiresIn = cibaConfig.getExpiresIn();
        int poolingInterval = cibaConfig.getPoolingInterval();
        String cibaMode = cibaConfig.getBackchannelTokenDeliveryMode(client);
        if (!"ping".equals(cibaMode)) {
            authReqId = null;
        }
        OAuth2DeviceCodeModel deviceCode = OAuth2DeviceCodeModel.create((RealmModel)this.realm, (ClientModel)client, (String)request.getId(), (String)request.getScope(), null, (int)expiresIn, (int)poolingInterval, (String)request.getClientNotificationToken(), (String)authReqId, Collections.emptyMap(), null, null);
        String authResultId = request.getAuthResultId();
        OAuth2DeviceUserCodeModel userCode = new OAuth2DeviceUserCodeModel(this.realm, deviceCode.getDeviceCode(), authResultId);
        int lifespanSeconds = expiresIn + poolingInterval + 10;
        SingleUseObjectProvider singleUseStore = this.session.singleUseObjects();
        singleUseStore.put(deviceCode.serializeKey(), (long)lifespanSeconds, deviceCode.toMap());
        singleUseStore.put(userCode.serializeKey(), (long)lifespanSeconds, userCode.serializeValue());
    }

    private CIBAAuthenticationRequest authorizeClient(MultivaluedMap<String, String> params) {
        ClientModel client = null;
        try {
            client = this.authenticateClient();
        }
        catch (WebApplicationException wae) {
            OAuth2ErrorRepresentation errorRep = (OAuth2ErrorRepresentation)wae.getResponse().getEntity();
            throw new ErrorResponseException(errorRep.getError(), errorRep.getErrorDescription(), Response.Status.UNAUTHORIZED);
        }
        BackchannelAuthenticationEndpointRequest endpointRequest = BackchannelAuthenticationEndpointRequestParserProcessor.parseRequest(this.event, this.session, client, params, this.realm.getCibaPolicy());
        UserModel user = this.resolveUser(endpointRequest, this.realm.getCibaPolicy().getAuthRequestedUserHint());
        CIBAAuthenticationRequest request = new CIBAAuthenticationRequest(this.session, user, client);
        request.setClient(client);
        String scope = endpointRequest.getScope();
        if (scope == null) {
            throw new ErrorResponseException("invalid_request", "missing parameter : scope", Response.Status.BAD_REQUEST);
        }
        if (!TokenManager.isValidScope(scope, client)) {
            throw new ErrorResponseException("invalid_request", "Invalid scopes: " + scope, Response.Status.BAD_REQUEST);
        }
        request.setScope(scope);
        if (endpointRequest.getBindingMessage() != null) {
            this.validateBindingMessage(endpointRequest.getBindingMessage());
            request.setBindingMessage(endpointRequest.getBindingMessage());
        }
        if (endpointRequest.getAcr() != null) {
            request.setAcrValues(endpointRequest.getAcr());
        }
        CibaConfig policy = this.realm.getCibaPolicy();
        Integer expiresIn = Optional.ofNullable(endpointRequest.getRequestedExpiry()).orElse(policy.getExpiresIn());
        request.exp(request.getIat() + expiresIn.longValue());
        StringBuilder scopes = new StringBuilder(Optional.ofNullable(request.getScope()).orElse(""));
        client.getClientScopes(true).forEach((key, value) -> {
            if (value.isDisplayOnConsentScreen()) {
                scopes.append(" ").append(value.getName());
            }
        });
        request.setScope(scopes.toString());
        if (endpointRequest.getClientNotificationToken() != null) {
            if (!policy.getBackchannelTokenDeliveryMode(client).equals("ping")) {
                throw new ErrorResponseException("invalid_request", "Client Notification token supported only for the ping mode", Response.Status.BAD_REQUEST);
            }
            if (endpointRequest.getClientNotificationToken().length() > 1024) {
                throw new ErrorResponseException("invalid_request", "Client Notification token length is limited to 1024 characters", Response.Status.BAD_REQUEST);
            }
            request.setClientNotificationToken(endpointRequest.getClientNotificationToken());
        }
        if (endpointRequest.getClientNotificationToken() == null && policy.getBackchannelTokenDeliveryMode(client).equals("ping")) {
            throw new ErrorResponseException("invalid_request", "Client Notification token needs to be provided with the ping mode", Response.Status.BAD_REQUEST);
        }
        if (endpointRequest.getUserCode() != null) {
            throw new ErrorResponseException("invalid_request", "User code not supported", Response.Status.BAD_REQUEST);
        }
        this.extractAdditionalParams(endpointRequest, request);
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new BackchannelAuthenticationRequestContext(endpointRequest, request, params));
        }
        catch (ClientPolicyException cpe) {
            throw new ErrorResponseException(cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        return request;
    }

    protected void extractAdditionalParams(BackchannelAuthenticationEndpointRequest endpointRequest, CIBAAuthenticationRequest request) {
        for (String paramName : endpointRequest.getAdditionalReqParams().keySet()) {
            request.setOtherClaims(paramName, endpointRequest.getAdditionalReqParams().get(paramName));
        }
    }

    protected void validateBindingMessage(String bindingMessage) {
        if (!BINDING_MESSAGE_VALIDATION.matcher(bindingMessage).matches()) {
            throw new ErrorResponseException("invalid_binding_message", "the binding_message value has to be max 50 characters in length and must contain only basic plain-text characters without spaces", Response.Status.BAD_REQUEST);
        }
    }

    private UserModel resolveUser(BackchannelAuthenticationEndpointRequest endpointRequest, String authRequestedUserHint) {
        UserModel user;
        CIBALoginUserResolver resolver = (CIBALoginUserResolver)this.session.getProvider(CIBALoginUserResolver.class);
        if (resolver == null) {
            throw new RuntimeException("CIBA Login User Resolver not setup properly.");
        }
        if (authRequestedUserHint.equals("login_hint")) {
            String userHint = endpointRequest.getLoginHint();
            if (userHint == null) {
                throw new ErrorResponseException("invalid_request", "missing parameter : login_hint", Response.Status.BAD_REQUEST);
            }
            user = resolver.getUserFromLoginHint(userHint);
        } else if (authRequestedUserHint.equals("id_token_hint")) {
            String userHint = endpointRequest.getIdTokenHint();
            if (userHint == null) {
                throw new ErrorResponseException("invalid_request", "missing parameter : id_token_hint", Response.Status.BAD_REQUEST);
            }
            user = resolver.getUserFromIdTokenHint(userHint);
        } else if (authRequestedUserHint.equals("login_hint_token")) {
            String userHint = endpointRequest.getLoginHintToken();
            if (userHint == null) {
                throw new ErrorResponseException("invalid_request", "missing parameter : login_hint_token", Response.Status.BAD_REQUEST);
            }
            user = resolver.getUserFromLoginHintToken(userHint);
        } else {
            throw new ErrorResponseException("invalid_request", "invalid user hint", Response.Status.BAD_REQUEST);
        }
        if (user == null || !user.isEnabled()) {
            throw new ErrorResponseException("invalid_request", "invalid user", Response.Status.BAD_REQUEST);
        }
        return user;
    }
}

