/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.broker;

import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.broker.AbstractIdpAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.ExistingUserInfo;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.services.ServicesLogger;

public class IdpCreateUserIfUniqueAuthenticator
extends AbstractIdpAuthenticator {
    private static Logger logger = Logger.getLogger(IdpCreateUserIfUniqueAuthenticator.class);

    @Override
    protected void actionImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
    }

    @Override
    protected void authenticateImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        KeycloakSession session = context.getSession();
        RealmModel realm = context.getRealm();
        if (context.getAuthenticationSession().getAuthNote("EXISTING_USER_INFO") != null) {
            context.attempted();
            return;
        }
        String username = this.getUsername(context, serializedCtx, brokerContext);
        if (username == null) {
            ServicesLogger.LOGGER.resetFlow(realm.isRegistrationEmailAsUsername() ? "Email" : "Username");
            context.getAuthenticationSession().setAuthNote("ENFORCE_UPDATE_PROFILE", "true");
            context.resetFlow();
            return;
        }
        ExistingUserInfo duplication = brokerContext.getIdpConfig().isTransientUsers() ? null : this.checkExistingUser(context, username, serializedCtx, brokerContext);
        UserModel federatedUser = null;
        if (brokerContext.getIdpConfig().isTransientUsers()) {
            logger.debugf("Transient brokering requested. Recording user details for account '%s' and from identity provider '%s' .", (Object)username, (Object)brokerContext.getIdpConfig().getAlias());
            federatedUser = new LightweightUserAdapter(session, context.getAuthenticationSession().getParentSession().getId());
            federatedUser.setUsername(username);
        } else if (duplication == null) {
            logger.debugf("No duplication detected. Creating account for user '%s' and linking with identity provider '%s' .", (Object)username, (Object)brokerContext.getIdpConfig().getAlias());
            federatedUser = session.users().addUser(realm, username);
        }
        if (federatedUser != null) {
            federatedUser.setEnabled(true);
            for (Map.Entry<String, List<String>> attr : serializedCtx.getAttributes().entrySet()) {
                if ("username".equalsIgnoreCase(attr.getKey())) continue;
                federatedUser.setAttribute(attr.getKey(), attr.getValue());
            }
            AuthenticatorConfigModel config = context.getAuthenticatorConfig();
            if (config != null && Boolean.parseBoolean((String)config.getConfig().get("require.password.update.after.registration"))) {
                logger.debugf("User '%s' required to update password", (Object)federatedUser.getUsername());
                federatedUser.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
            }
            this.userRegisteredSuccess(context, federatedUser, serializedCtx, brokerContext);
            context.setUser(federatedUser);
            context.getAuthenticationSession().setAuthNote("BROKER_REGISTERED_NEW_USER", "true");
            context.success();
        } else {
            logger.debugf("Duplication detected. There is already existing user with %s '%s' .", (Object)duplication.getDuplicateAttributeName(), (Object)duplication.getDuplicateAttributeValue());
            context.getAuthenticationSession().setAuthNote("EXISTING_USER_INFO", duplication.serialize());
            if (context.getExecution().isRequired()) {
                Response challengeResponse = context.form().setError("federatedIdentityExistsMessage", new Object[]{duplication.getDuplicateAttributeName(), duplication.getDuplicateAttributeValue()}).createErrorPage(Response.Status.CONFLICT);
                context.challenge(challengeResponse);
                context.getEvent().user(duplication.getExistingUserId()).detail("existing_" + duplication.getDuplicateAttributeName(), duplication.getDuplicateAttributeValue()).removeDetail("auth_method").removeDetail("auth_type").error("federated_identity_account_exists");
            } else {
                context.attempted();
            }
        }
    }

    protected ExistingUserInfo checkExistingUser(AuthenticationFlowContext context, String username, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        UserModel existingUser;
        if (brokerContext.getEmail() != null && !context.getRealm().isDuplicateEmailsAllowed() && (existingUser = context.getSession().users().getUserByEmail(context.getRealm(), brokerContext.getEmail())) != null) {
            return new ExistingUserInfo(existingUser.getId(), "email", existingUser.getEmail());
        }
        existingUser = context.getSession().users().getUserByUsername(context.getRealm(), username);
        if (existingUser != null) {
            return new ExistingUserInfo(existingUser.getId(), "username", existingUser.getUsername());
        }
        return null;
    }

    protected String getUsername(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        RealmModel realm = context.getRealm();
        return realm.isRegistrationEmailAsUsername() ? brokerContext.getEmail() : brokerContext.getModelUsername();
    }

    protected void userRegisteredSuccess(AuthenticationFlowContext context, UserModel registeredUser, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }
}

