/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.google;

import java.util.List;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProviderFactory;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.social.google.GoogleIdentityProvider;
import org.keycloak.social.google.GoogleIdentityProviderConfig;

public class GoogleIdentityProviderFactory
extends AbstractIdentityProviderFactory<GoogleIdentityProvider>
implements SocialIdentityProviderFactory<GoogleIdentityProvider> {
    public static final String PROVIDER_ID = "google";

    public String getName() {
        return "Google";
    }

    public GoogleIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new GoogleIdentityProvider(session, new GoogleIdentityProviderConfig(model));
    }

    public GoogleIdentityProviderConfig createConfig() {
        return new GoogleIdentityProviderConfig();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name("hostedDomain").label("Hosted Domain").helpText("Set 'hd' query parameter when logging in with Google. Google will list accounts only for this domain. Keycloak validates that the returned identity token has a claim for this domain. When '*' is entered, any hosted account can be used. Comma ',' separated list of domains is supported.").type("String").add().property().name("userIp").label("Use userIp param").helpText("Set 'userIp' query parameter when invoking on Google's User Info service.  This will use the user's ip address.  Useful if Google is throttling access to the User Info service.").type("boolean").add().property().name("offlineAccess").label("Request refresh token").helpText("Set 'access_type' query parameter to 'offline' when redirecting to google authorization endpoint, to get a refresh token back. Useful if planning to use Token Exchange to retrieve Google token to access Google APIs when the user is not at the browser.").type("boolean").add().build();
    }
}

