/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.par.endpoints.request;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import org.keycloak.common.Profile;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointQueryStringParser;
import org.keycloak.protocol.oidc.par.endpoints.request.ParEndpointRequestObjectParser;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.util.AuthorizationContextUtil;

public class ParEndpointRequestParserProcessor {
    public static AuthorizationEndpointRequest parseRequest(EventBuilder event, KeycloakSession session, ClientModel client, MultivaluedMap<String, String> requestParams) {
        try {
            AuthorizationEndpointRequest request = new AuthorizationEndpointRequest();
            AuthzEndpointQueryStringParser parser = new AuthzEndpointQueryStringParser(requestParams, false);
            parser.parseRequest(request);
            if (parser.getInvalidRequestMessage() != null) {
                request.setInvalidRequestMessage(parser.getInvalidRequestMessage());
            }
            if (request.getInvalidRequestMessage() != null) {
                return request;
            }
            String requestParam = (String)requestParams.getFirst((Object)"request");
            String requestUriParam = (String)requestParams.getFirst((Object)"request_uri");
            if (requestParam != null && requestUriParam != null) {
                throw new RuntimeException("Illegal to use both 'request' and 'request_uri' parameters together");
            }
            String requestObjectRequired = OIDCAdvancedConfigWrapper.fromClientModel(client).getRequestObjectRequired();
            if ("request or request_uri".equals(requestObjectRequired) && requestParam == null && requestUriParam == null) {
                throw new RuntimeException("Client is required to use 'request' or 'request_uri' parameter.");
            }
            if ("request only".equals(requestObjectRequired) && requestParam == null) {
                throw new RuntimeException("Client is required to use 'request' parameter.");
            }
            if ("request_uri only".equals(requestObjectRequired) && requestUriParam == null) {
                throw new RuntimeException("Client is required to use 'request_uri' parameter.");
            }
            if (requestParam != null) {
                new ParEndpointRequestObjectParser(session, requestParam, client).parseRequest(request);
            } else if (requestUriParam != null) {
                List<String> requestUris = OIDCAdvancedConfigWrapper.fromClientModel(client).getRequestUris();
                String requestUri = RedirectUtils.verifyRedirectUri(session, client.getRootUrl(), requestUriParam, new HashSet<String>(requestUris), false);
                if (requestUri == null) {
                    throw new RuntimeException("Specified 'request_uri' not allowed for this client.");
                }
                try (InputStream is = ((HttpClientProvider)session.getProvider(HttpClientProvider.class)).get(requestUri);){
                    String retrievedRequest = StreamUtil.readString((InputStream)is);
                    new ParEndpointRequestObjectParser(session, retrievedRequest, client).parseRequest(request);
                }
            }
            if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES)) {
                request.setAuthorizationRequestContext(AuthorizationContextUtil.getAuthorizationRequestContextFromScopes(session, request.getScope()));
            }
            return request;
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.invalidRequest(e);
            event.error("invalid_request");
            throw new ErrorPageException(session, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
        }
    }
}

