/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;

public class OIDCIdentityProviderConfig
extends OAuth2IdentityProviderConfig {
    public static final String JWKS_URL = "jwksUrl";
    public static final String USE_JWKS_URL = "useJwksUrl";
    public static final String VALIDATE_SIGNATURE = "validateSignature";
    public static final String IS_ACCESS_TOKEN_JWT = "isAccessTokenJWT";

    public OIDCIdentityProviderConfig(IdentityProviderModel identityProviderModel) {
        super(identityProviderModel);
    }

    public OIDCIdentityProviderConfig() {
    }

    @Override
    public String getPrompt() {
        return (String)this.getConfig().get("prompt");
    }

    public void setPrompt(String prompt) {
        this.getConfig().put("prompt", prompt);
    }

    public String getIssuer() {
        return (String)this.getConfig().get("issuer");
    }

    public void setIssuer(String issuer) {
        this.getConfig().put("issuer", issuer);
    }

    public String getLogoutUrl() {
        return (String)this.getConfig().get("logoutUrl");
    }

    public void setLogoutUrl(String url) {
        this.getConfig().put("logoutUrl", url);
    }

    public String getPublicKeySignatureVerifier() {
        return (String)this.getConfig().get("publicKeySignatureVerifier");
    }

    public void setPublicKeySignatureVerifier(String signingCertificate) {
        this.getConfig().put("publicKeySignatureVerifier", signingCertificate);
    }

    public String getPublicKeySignatureVerifierKeyId() {
        return (String)this.getConfig().get("publicKeySignatureVerifierKeyId");
    }

    public void setPublicKeySignatureVerifierKeyId(String publicKeySignatureVerifierKeyId) {
        this.getConfig().put("publicKeySignatureVerifierKeyId", publicKeySignatureVerifierKeyId);
    }

    public boolean isValidateSignature() {
        return Boolean.valueOf((String)this.getConfig().get(VALIDATE_SIGNATURE));
    }

    public void setValidateSignature(boolean validateSignature) {
        this.getConfig().put(VALIDATE_SIGNATURE, String.valueOf(validateSignature));
    }

    public void setAccessTokenJwt(boolean accessTokenJwt) {
        this.getConfig().put(IS_ACCESS_TOKEN_JWT, String.valueOf(accessTokenJwt));
    }

    public boolean isAccessTokenJwt() {
        return Boolean.parseBoolean((String)this.getConfig().get(IS_ACCESS_TOKEN_JWT));
    }

    public boolean isUseJwksUrl() {
        return Boolean.valueOf((String)this.getConfig().get(USE_JWKS_URL));
    }

    public void setUseJwksUrl(boolean useJwksUrl) {
        this.getConfig().put(USE_JWKS_URL, String.valueOf(useJwksUrl));
    }

    public String getJwksUrl() {
        return (String)this.getConfig().get(JWKS_URL);
    }

    public void setJwksUrl(String jwksUrl) {
        this.getConfig().put(JWKS_URL, jwksUrl);
    }

    public boolean isBackchannelSupported() {
        return Boolean.valueOf((String)this.getConfig().get("backchannelSupported"));
    }

    public void setBackchannelSupported(boolean backchannel) {
        this.getConfig().put("backchannelSupported", String.valueOf(backchannel));
    }

    public boolean isDisableUserInfoService() {
        String disableUserInfo = (String)this.getConfig().get("disableUserInfo");
        return Boolean.parseBoolean(disableUserInfo);
    }

    public void setDisableUserInfoService(boolean disable) {
        this.getConfig().put("disableUserInfo", String.valueOf(disable));
    }

    public boolean isDisableNonce() {
        return Boolean.parseBoolean((String)this.getConfig().get("disableNonce"));
    }

    public void setDisableNonce(boolean disableNonce) {
        if (disableNonce) {
            this.getConfig().put("disableNonce", Boolean.TRUE.toString());
        } else {
            this.getConfig().remove("disableNonce");
        }
    }

    public int getAllowedClockSkew() {
        String allowedClockSkew = (String)this.getConfig().get("allowedClockSkew");
        if (allowedClockSkew == null || allowedClockSkew.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt((String)this.getConfig().get("allowedClockSkew"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public void validate(RealmModel realm) {
        super.validate(realm);
        SslRequired sslRequired = realm.getSslRequired();
        UriUtils.checkUrl((SslRequired)sslRequired, (String)this.getJwksUrl(), (String)"jwks_url");
        UriUtils.checkUrl((SslRequired)sslRequired, (String)this.getLogoutUrl(), (String)"logout_url");
    }
}

