/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme.beans;

import jakarta.ws.rs.core.UriBuilder;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.keycloak.models.RealmModel;

public class LocaleBean {
    private String current;
    private String currentLanguageTag;
    private List<Locale> supported;

    public LocaleBean(RealmModel realm, java.util.Locale current, UriBuilder uriBuilder, Properties messages) {
        this.currentLanguageTag = current.toLanguageTag();
        this.current = messages.getProperty("locale_" + this.currentLanguageTag, this.currentLanguageTag);
        this.supported = realm.getSupportedLocalesStream().map(l -> {
            String label = messages.getProperty("locale_" + l, (String)l);
            String url = uriBuilder.replaceQueryParam("kc_locale", new Object[]{l}).build(new Object[0]).toString();
            return new Locale((String)l, label, url);
        }).collect(Collectors.toList());
    }

    public String getCurrent() {
        return this.current;
    }

    public String getCurrentLanguageTag() {
        return this.currentLanguageTag;
    }

    public List<Locale> getSupported() {
        return this.supported;
    }

    public static class Locale {
        private String languageTag;
        private String label;
        private String url;

        public Locale(String languageTag, String label, String url) {
            this.languageTag = languageTag;
            this.label = label;
            this.url = url;
        }

        public String getLanguageTag() {
            return this.languageTag;
        }

        public String getUrl() {
            return this.url;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

