/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.InputStream;
import org.keycloak.common.Version;
import org.keycloak.common.util.MimeTypeUtil;
import org.keycloak.encoding.ResourceEncodingHelper;
import org.keycloak.encoding.ResourceEncodingProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.theme.Theme;

@Path(value="/resources")
public class ThemeResource {
    @Context
    private KeycloakSession session;

    @GET
    @Path(value="/{version}/{themeType}/{themeName}/{path:.*}")
    public Response getResource(@PathParam(value="version") String version, @PathParam(value="themeType") String themType, @PathParam(value="themeName") String themeName, @PathParam(value="path") String path) {
        if (!version.equals(Version.RESOURCES_VERSION)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            String contentType = MimeTypeUtil.getContentType((String)path);
            Theme theme = this.session.theme().getTheme(themeName, Theme.Type.valueOf((String)themType.toUpperCase()));
            ResourceEncodingProvider encodingProvider = this.session.theme().isCacheEnabled() ? ResourceEncodingHelper.getResourceEncodingProvider(this.session, contentType) : null;
            InputStream resource = encodingProvider != null ? encodingProvider.getEncodedStream(() -> theme.getResourceAsStream(path), themType, themeName, path.replace('/', File.separatorChar)) : theme.getResourceAsStream(path);
            if (resource != null) {
                Response.ResponseBuilder rb = Response.ok((Object)resource).type(contentType).cacheControl(CacheControlUtil.getDefaultCacheControl());
                if (encodingProvider != null) {
                    rb.encoding(encodingProvider.getEncoding());
                }
                return rb.build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.failedToGetThemeRequest(e);
            return Response.serverError().build();
        }
    }
}

