/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.regex.Pattern;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.keycloak.TokenVerifier;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationManager;

public class AppAuthManager
extends AuthenticationManager {
    private static final String BEARER = "Bearer";
    private static final Pattern WHITESPACES = Pattern.compile("\\s+");

    @Override
    public AuthenticationManager.AuthResult authenticateIdentityCookie(KeycloakSession session, RealmModel realm) {
        AuthenticationManager.AuthResult authResult = super.authenticateIdentityCookie(session, realm);
        if (authResult == null) {
            return null;
        }
        AppAuthManager.createLoginCookie(session, realm, authResult.getUser(), authResult.getSession(), (UriInfo)session.getContext().getUri(), session.getContext().getConnection());
        if (authResult.getSession().isRememberMe()) {
            AppAuthManager.createRememberMeCookie(authResult.getUser().getUsername(), (UriInfo)session.getContext().getUri(), session);
        }
        return authResult;
    }

    private static String extractTokenStringFromAuthHeader(String authHeader) {
        if (authHeader == null) {
            return null;
        }
        String[] split = WHITESPACES.split(authHeader.trim());
        if (split.length != 2) {
            return null;
        }
        String bearerPart = split[0];
        if (!bearerPart.equalsIgnoreCase(BEARER)) {
            return null;
        }
        String tokenString = split[1];
        if (ObjectUtil.isBlank((CharSequence)tokenString)) {
            return null;
        }
        return tokenString;
    }

    public static String extractAuthorizationHeaderTokenOrReturnNull(HttpHeaders headers) {
        String authHeader = (String)headers.getRequestHeaders().getFirst((Object)"Authorization");
        return AppAuthManager.extractTokenStringFromAuthHeader(authHeader);
    }

    public static String extractAuthorizationHeaderToken(HttpHeaders headers) {
        String authHeader = (String)headers.getRequestHeaders().getFirst((Object)"Authorization");
        if (authHeader == null) {
            return null;
        }
        String tokenString = AppAuthManager.extractTokenStringFromAuthHeader(authHeader);
        if (tokenString == null) {
            throw new NotAuthorizedException((Object)BEARER, new Object[0]);
        }
        return tokenString;
    }

    public static class BearerTokenAuthenticator {
        private KeycloakSession session;
        private RealmModel realm;
        private UriInfo uriInfo;
        private ClientConnection connection;
        private HttpHeaders headers;
        private String tokenString;
        private String audience;

        public BearerTokenAuthenticator(KeycloakSession session) {
            this.session = session;
        }

        public BearerTokenAuthenticator setSession(KeycloakSession session) {
            this.session = session;
            return this;
        }

        public BearerTokenAuthenticator setRealm(RealmModel realm) {
            this.realm = realm;
            return this;
        }

        public BearerTokenAuthenticator setUriInfo(UriInfo uriInfo) {
            this.uriInfo = uriInfo;
            return this;
        }

        public BearerTokenAuthenticator setConnection(ClientConnection connection) {
            this.connection = connection;
            return this;
        }

        public BearerTokenAuthenticator setHeaders(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public BearerTokenAuthenticator setTokenString(String tokenString) {
            this.tokenString = tokenString;
            return this;
        }

        public BearerTokenAuthenticator setAudience(String audience) {
            this.audience = audience;
            return this;
        }

        public AuthenticationManager.AuthResult authenticate() {
            KeycloakContext ctx = this.session.getContext();
            if (this.realm == null) {
                this.realm = ctx.getRealm();
            }
            if (this.uriInfo == null) {
                this.uriInfo = ctx.getUri();
            }
            if (this.connection == null) {
                this.connection = ctx.getConnection();
            }
            if (this.headers == null) {
                this.headers = ctx.getRequestHeaders();
            }
            if (this.tokenString == null) {
                this.tokenString = AppAuthManager.extractAuthorizationHeaderToken(this.headers);
            }
            return AuthenticationManager.verifyIdentityToken(this.session, this.realm, this.uriInfo, this.connection, true, true, this.audience, false, this.tokenString, this.headers, new TokenVerifier.Predicate[0]);
        }
    }
}

