/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.info;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.Profile;
import org.keycloak.component.ComponentFactory;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PasswordPolicyProviderFactory;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.provider.Spi;
import org.keycloak.representations.idm.ComponentTypeRepresentation;
import org.keycloak.representations.idm.PasswordPolicyTypeRepresentation;
import org.keycloak.representations.idm.ProtocolMapperTypeRepresentation;
import org.keycloak.representations.info.ClientInstallationRepresentation;
import org.keycloak.representations.info.CryptoInfoRepresentation;
import org.keycloak.representations.info.MemoryInfoRepresentation;
import org.keycloak.representations.info.ProfileInfoRepresentation;
import org.keycloak.representations.info.ProviderRepresentation;
import org.keycloak.representations.info.ServerInfoRepresentation;
import org.keycloak.representations.info.SpiInfoRepresentation;
import org.keycloak.representations.info.SystemInfoRepresentation;
import org.keycloak.representations.info.ThemeInfoRepresentation;
import org.keycloak.theme.Theme;

public class ServerInfoAdminResource {
    private static final Map<String, List<String>> ENUMS = ServerInfoAdminResource.createEnumsMap(EventType.class, OperationType.class, ResourceType.class);
    private final KeycloakSession session;

    public ServerInfoAdminResource(KeycloakSession session) {
        this.session = session;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public ServerInfoRepresentation getInfo() {
        ServerInfoRepresentation info = new ServerInfoRepresentation();
        info.setSystemInfo(SystemInfoRepresentation.create((long)this.session.getKeycloakSessionFactory().getServerStartupTimestamp()));
        info.setMemoryInfo(MemoryInfoRepresentation.create());
        info.setProfileInfo(ProfileInfoRepresentation.create());
        info.setCryptoInfo(CryptoInfoRepresentation.create());
        this.setSocialProviders(info);
        this.setIdentityProviders(info);
        this.setThemes(info);
        this.setProviders(info);
        this.setProtocolMapperTypes(info);
        this.setBuiltinProtocolMappers(info);
        this.setClientInstallations(info);
        this.setPasswordPolicies(info);
        info.setEnums(ENUMS);
        return info;
    }

    private void setProviders(ServerInfoRepresentation info) {
        info.setComponentTypes(new HashMap());
        LinkedHashMap<String, SpiInfoRepresentation> spiReps = new LinkedHashMap<String, SpiInfoRepresentation>();
        LinkedList spis = new LinkedList(this.session.getKeycloakSessionFactory().getSpis());
        Collections.sort(spis, new Comparator<Spi>(){

            @Override
            public int compare(Spi s1, Spi s2) {
                return s1.getName().compareTo(s2.getName());
            }
        });
        for (Spi spi : spis) {
            SpiInfoRepresentation spiRep = new SpiInfoRepresentation();
            spiRep.setInternal(spi.isInternal());
            LinkedList providerIds = new LinkedList(this.session.listProviderIds(spi.getProviderClass()));
            Collections.sort(providerIds);
            HashMap<String, ProviderRepresentation> providers = new HashMap<String, ProviderRepresentation>();
            if (providerIds != null) {
                for (String name : providerIds) {
                    ProviderRepresentation provider = new ProviderRepresentation();
                    ProviderFactory pi = this.session.getKeycloakSessionFactory().getProviderFactory(spi.getProviderClass(), name);
                    provider.setOrder(pi.order());
                    if (ServerInfoAwareProviderFactory.class.isAssignableFrom(pi.getClass())) {
                        provider.setOperationalInfo(((ServerInfoAwareProviderFactory)pi).getOperationalInfo());
                    }
                    if (pi instanceof ConfiguredProvider) {
                        LinkedList<ComponentTypeRepresentation> reps;
                        ComponentTypeRepresentation rep = new ComponentTypeRepresentation();
                        rep.setId(pi.getId());
                        ConfiguredProvider configured = (ConfiguredProvider)pi;
                        rep.setHelpText(configured.getHelpText());
                        List configProperties = configured.getConfigProperties();
                        if (configProperties == null) {
                            configProperties = Collections.EMPTY_LIST;
                        }
                        rep.setProperties(ModelToRepresentation.toRepresentation((List)configProperties));
                        if (pi instanceof ComponentFactory) {
                            rep.setMetadata(((ComponentFactory)pi).getTypeMetadata());
                        }
                        if ((reps = (LinkedList<ComponentTypeRepresentation>)info.getComponentTypes().get(spi.getProviderClass().getName())) == null) {
                            reps = new LinkedList<ComponentTypeRepresentation>();
                            info.getComponentTypes().put(spi.getProviderClass().getName(), reps);
                        }
                        reps.add(rep);
                    }
                    providers.put(name, provider);
                }
            }
            spiRep.setProviders(providers);
            spiReps.put(spi.getName(), spiRep);
        }
        info.setProviders(spiReps);
    }

    private void setThemes(ServerInfoRepresentation info) {
        info.setThemes(new HashMap());
        for (Theme.Type type : Theme.Type.values()) {
            LinkedList<String> themeNames = this.filterThemes(type, new LinkedList<String>(this.session.theme().nameSet(type)));
            Collections.sort(themeNames);
            LinkedList<ThemeInfoRepresentation> themes = new LinkedList<ThemeInfoRepresentation>();
            info.getThemes().put(type.toString().toLowerCase(), themes);
            for (String name : themeNames) {
                try {
                    Theme theme = this.session.theme().getTheme(name, type);
                    if (theme == null || !name.equals(theme.getName())) continue;
                    ThemeInfoRepresentation ti = new ThemeInfoRepresentation();
                    ti.setName(name);
                    String locales = theme.getProperties().getProperty("locales");
                    if (locales != null) {
                        ti.setLocales(locales.replaceAll(" ", "").split(","));
                    }
                    themes.add(ti);
                }
                catch (IOException e) {
                    throw new WebApplicationException("Failed to load themes", (Throwable)e);
                }
            }
        }
    }

    private LinkedList<String> filterThemes(Theme.Type type, LinkedList<String> themeNames) {
        boolean filterAdminV2;
        LinkedList<String> filteredNames = new LinkedList<String>(themeNames);
        boolean filterAccountV2 = type == Theme.Type.ACCOUNT && !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ACCOUNT2);
        boolean bl = filterAdminV2 = type == Theme.Type.ADMIN && !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN2);
        if (filterAccountV2 || filterAdminV2) {
            filteredNames.remove("keycloak.v2");
            filteredNames.remove("rh-sso.v2");
        }
        return filteredNames;
    }

    private void setSocialProviders(ServerInfoRepresentation info) {
        info.setSocialProviders(new LinkedList());
        Stream providerFactories = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(SocialIdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.getSocialProviders(), "Social");
    }

    private void setIdentityProviders(ServerInfoRepresentation info) {
        info.setIdentityProviders(new LinkedList());
        Stream providerFactories = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(IdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.getIdentityProviders(), "User-defined");
        providerFactories = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(SocialIdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.getIdentityProviders(), "Social");
    }

    public void setIdentityProviders(Stream<ProviderFactory> factories, List<Map<String, String>> providers, String groupName) {
        List providerMaps = factories.map(IdentityProviderFactory.class::cast).map(factory -> {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("groupName", groupName);
            data.put("name", factory.getName());
            data.put("id", factory.getId());
            return data;
        }).collect(Collectors.toList());
        providers.addAll(providerMaps);
    }

    private void setClientInstallations(ServerInfoRepresentation info) {
        HashMap clientInstallations = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(ClientInstallationProvider.class).map(ClientInstallationProvider.class::cast).collect(Collectors.toMap(ClientInstallationProvider::getProtocol, this::toClientInstallationRepresentation, (l1, l2) -> ServerInfoAdminResource.listCombiner(l1, l2), HashMap::new));
        info.setClientInstallations((Map)clientInstallations);
    }

    private void setProtocolMapperTypes(ServerInfoRepresentation info) {
        HashMap protocolMappers = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(ProtocolMapper.class).map(ProtocolMapper.class::cast).collect(Collectors.toMap(ProtocolMapper::getProtocol, this::toProtocolMapperTypeRepresentation, (l1, l2) -> ServerInfoAdminResource.listCombiner(l1, l2), HashMap::new));
        info.setProtocolMapperTypes((Map)protocolMappers);
    }

    private void setBuiltinProtocolMappers(ServerInfoRepresentation info) {
        Map<String, List> protocolMappers = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(LoginProtocol.class).collect(Collectors.toMap(p -> p.getId(), p -> {
            LoginProtocolFactory factory = (LoginProtocolFactory)p;
            return factory.getBuiltinMappers().values().stream().map(ModelToRepresentation::toRepresentation).collect(Collectors.toList());
        }));
        info.setBuiltinProtocolMappers(protocolMappers);
    }

    private void setPasswordPolicies(ServerInfoRepresentation info) {
        List passwordPolicyTypes = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(PasswordPolicyProvider.class).map(PasswordPolicyProviderFactory.class::cast).map(factory -> {
            PasswordPolicyTypeRepresentation rep = new PasswordPolicyTypeRepresentation();
            rep.setId(factory.getId());
            rep.setDisplayName(factory.getDisplayName());
            rep.setConfigType(factory.getConfigType());
            rep.setDefaultValue(factory.getDefaultConfigValue());
            rep.setMultipleSupported(factory.isMultiplSupported());
            return rep;
        }).collect(Collectors.toList());
        info.setPasswordPolicies(passwordPolicyTypes);
    }

    private List<ClientInstallationRepresentation> toClientInstallationRepresentation(ClientInstallationProvider provider) {
        ClientInstallationRepresentation rep = new ClientInstallationRepresentation();
        rep.setId(provider.getId());
        rep.setHelpText(provider.getHelpText());
        rep.setDisplayType(provider.getDisplayType());
        rep.setProtocol(provider.getProtocol());
        rep.setDownloadOnly(provider.isDownloadOnly());
        rep.setFilename(provider.getFilename());
        rep.setMediaType(provider.getMediaType());
        return Arrays.asList(rep);
    }

    private List<ProtocolMapperTypeRepresentation> toProtocolMapperTypeRepresentation(ProtocolMapper mapper) {
        ProtocolMapperTypeRepresentation rep = new ProtocolMapperTypeRepresentation();
        rep.setId(mapper.getId());
        rep.setName(mapper.getDisplayType());
        rep.setHelpText(mapper.getHelpText());
        rep.setCategory(mapper.getDisplayCategory());
        rep.setPriority(mapper.getPriority());
        List configProperties = mapper.getConfigProperties();
        rep.setProperties(ModelToRepresentation.toRepresentation((List)configProperties));
        return Arrays.asList(rep);
    }

    private static <T> List<T> listCombiner(List<T> list1, List<T> list2) {
        return Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList());
    }

    private static Map<String, List<String>> createEnumsMap(Class ... enums) {
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        for (Class e : enums) {
            String n = e.getSimpleName();
            n = Character.toLowerCase(n.charAt(0)) + n.substring(1);
            LinkedList<String> l = new LinkedList<String>();
            for (Object c : e.getEnumConstants()) {
                l.add(c.toString());
            }
            Collections.sort(l);
            m.put(n, l);
        }
        return m;
    }
}

