/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.representations.ClaimsRepresentation;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.util.JsonSerialization;

public class IntentClientBindCheckExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(IntentClientBindCheckExecutor.class);
    private final KeycloakSession session;
    private Configuration configuration;

    public IntentClientBindCheckExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "intent-client-bind-checker";
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = Optional.ofNullable(config).orElse(this.createDefaultConfiguration());
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: {
                this.checkIntentClientBind((AuthorizationRequestContext)context);
                break;
            }
            default: {
                return;
            }
        }
    }

    private Configuration createDefaultConfiguration() {
        Configuration conf = new Configuration();
        return conf;
    }

    private void checkIntentClientBind(AuthorizationRequestContext context) throws ClientPolicyException {
        if (!this.isValidIntentClientBindCheckEndpoint()) {
            throw new ClientPolicyException("server_error", "invalid Intent Client Bind Check Endpoint setting");
        }
        ClientModel client = this.session.getContext().getClient();
        String clientId = client.getClientId();
        String intentId = this.retrieveIntentId(context.getAuthorizationEndpointRequest());
        IntentBindCheckRequest request = new IntentBindCheckRequest();
        request.setClientId(clientId);
        request.setIntentId(intentId);
        SimpleHttp simpleHttp = SimpleHttp.doPost((String)this.configuration.getIntentClientBindCheckEndpoint(), (KeycloakSession)this.session).header("Content-Type", "application/json").json((Object)request);
        IntentBindCheckResponse response = null;
        try {
            response = (IntentBindCheckResponse)simpleHttp.asJson(IntentBindCheckResponse.class);
        }
        catch (IOException e) {
            logger.warnv("HTTP connection failure: {0}", (Object)e);
            throw new ClientPolicyException("invalid_request", "checking intent bound with client failed");
        }
        if (!response.isBound.booleanValue()) {
            logger.tracev("Not Bound: intentName = {0}, intentId = {1}, clientId = {2}", (Object)this.configuration.getIntentName(), (Object)intentId, (Object)clientId);
            throw new ClientPolicyException("invalid_request", "The intent is not bound with the client");
        }
        logger.tracev("Bound: intentName = {0}, intentId = {1}, clientId = {2}", (Object)this.configuration.getIntentName(), (Object)intentId, (Object)clientId);
    }

    private String retrieveIntentId(AuthorizationEndpointRequest request) throws ClientPolicyException {
        String claims = request.getClaims();
        if (claims == null || claims.isEmpty()) {
            throw new ClientPolicyException("invalid_request", "no claim for an intent value in an authorization request");
        }
        String intentName = this.configuration.getIntentName();
        if (intentName == null || intentName.isEmpty()) {
            throw new ClientPolicyException("invalid_request", "invalid intent name setting");
        }
        ClaimsRepresentation claimsRep = null;
        try {
            claimsRep = (ClaimsRepresentation)JsonSerialization.readValue((String)claims, ClaimsRepresentation.class);
        }
        catch (IOException e) {
            throw new ClientPolicyException("invalid_request", "invalid claim for an intent value");
        }
        if (!claimsRep.isPresent(intentName, ClaimsRepresentation.ClaimContext.ID_TOKEN) || claimsRep.isPresentAsNullClaim(intentName, ClaimsRepresentation.ClaimContext.ID_TOKEN)) {
            throw new ClientPolicyException("invalid_request", "no claim for an intent value for ID token");
        }
        ClaimsRepresentation.ClaimValue claimValue = claimsRep.getClaimValue(intentName, ClaimsRepresentation.ClaimContext.ID_TOKEN, String.class);
        if (!claimValue.isEssential()) {
            throw new ClientPolicyException("invalid_request", "not specifying a claim for an intent as essential claim");
        }
        String value = (String)claimValue.getValue();
        if (value == null) {
            throw new ClientPolicyException("invalid_request", "invalid intent value");
        }
        return value;
    }

    private boolean isValidIntentClientBindCheckEndpoint() {
        String endpoint = this.configuration.getIntentClientBindCheckEndpoint();
        if (endpoint == null) {
            return false;
        }
        return endpoint.startsWith("http://") || endpoint.startsWith("https://");
    }

    public static class IntentBindCheckResponse
    implements Serializable {
        @JsonProperty(value="is_bound")
        private Boolean isBound;

        public Boolean getIsBound() {
            return this.isBound;
        }

        public void setIsBound(Boolean isBound) {
            this.isBound = isBound;
        }
    }

    public static class IntentBindCheckRequest
    implements Serializable {
        @JsonProperty(value="intent_id")
        private String intentId;
        @JsonProperty(value="client_id")
        private String clientId;

        public String getIntentId() {
            return this.intentId;
        }

        public void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="intent-client-bind-check-endpoint")
        protected String intentClientBindCheckEndpoint;
        @JsonProperty(value="intent-name")
        protected String intentName;

        public String getIntentClientBindCheckEndpoint() {
            return this.intentClientBindCheckEndpoint;
        }

        public void setIntentClientBindCheckEndpoint(String intentClientBindCheckEndpoint) {
            this.intentClientBindCheckEndpoint = intentClientBindCheckEndpoint;
        }

        public String getIntentName() {
            return this.intentName;
        }

        public void setIntentName(String intentName) {
            this.intentName = intentName;
        }
    }
}

