/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Resteasy;
import org.keycloak.locale.LocaleSelectorProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.HttpRequestImpl;
import org.keycloak.services.HttpResponseImpl;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.urls.UrlType;

public class DefaultKeycloakContext
implements KeycloakContext {
    private RealmModel realm;
    private ClientModel client;
    private KeycloakSession session;
    private Map<UrlType, KeycloakUriInfo> uriInfo;
    private AuthenticationSessionModel authenticationSession;
    private org.keycloak.http.HttpRequest request;
    private org.keycloak.http.HttpResponse response;

    public DefaultKeycloakContext(KeycloakSession session) {
        this.session = session;
    }

    public URI getAuthServerUrl() {
        return this.getUri(UrlType.FRONTEND).getBaseUri();
    }

    public String getContextPath() {
        return this.getUri(UrlType.FRONTEND).getBaseUri().getPath();
    }

    public KeycloakUriInfo getUri(UrlType type) {
        if (this.uriInfo == null || !this.uriInfo.containsKey(type)) {
            if (this.uriInfo == null) {
                this.uriInfo = new HashMap<UrlType, KeycloakUriInfo>();
            }
            this.uriInfo.put(type, new KeycloakUriInfo(this.session, type, this.getHttpRequest().getUri()));
        }
        return this.uriInfo.get(type);
    }

    public KeycloakUriInfo getUri() {
        return this.getUri(UrlType.FRONTEND);
    }

    @Deprecated
    public HttpHeaders getRequestHeaders() {
        return this.getHttpRequest().getHttpHeaders();
    }

    public <T> T getContextObject(Class<T> clazz) {
        return Resteasy.getContextData(clazz);
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public void setRealm(RealmModel realm) {
        this.realm = realm;
        this.uriInfo = null;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public void setClient(ClientModel client) {
        this.client = client;
    }

    public ClientConnection getConnection() {
        return this.getContextObject(ClientConnection.class);
    }

    public Locale resolveLocale(UserModel user) {
        return ((LocaleSelectorProvider)this.session.getProvider(LocaleSelectorProvider.class)).resolveLocale(this.getRealm(), user);
    }

    public AuthenticationSessionModel getAuthenticationSession() {
        return this.authenticationSession;
    }

    public void setAuthenticationSession(AuthenticationSessionModel authenticationSession) {
        this.authenticationSession = authenticationSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.keycloak.http.HttpRequest getHttpRequest() {
        if (this.request == null) {
            DefaultKeycloakContext defaultKeycloakContext = this;
            synchronized (defaultKeycloakContext) {
                this.request = this.getContextObject(org.keycloak.http.HttpRequest.class);
                if (this.request == null) {
                    this.request = this.createHttpRequest();
                }
            }
        }
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.keycloak.http.HttpResponse getHttpResponse() {
        if (this.response == null) {
            DefaultKeycloakContext defaultKeycloakContext = this;
            synchronized (defaultKeycloakContext) {
                this.response = this.getContextObject(org.keycloak.http.HttpResponse.class);
                if (this.response == null) {
                    this.response = this.createHttpResponse();
                }
            }
        }
        return this.response;
    }

    protected org.keycloak.http.HttpRequest createHttpRequest() {
        return new HttpRequestImpl(this.getContextObject(HttpRequest.class));
    }

    protected org.keycloak.http.HttpResponse createHttpResponse() {
        return new HttpResponseImpl(this.session, this.getContextObject(HttpResponse.class));
    }
}

