/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.OIDCProviderConfig;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.endpoints.AuthorizationEndpoint;
import org.keycloak.protocol.oidc.endpoints.LoginStatusIframeEndpoint;
import org.keycloak.protocol.oidc.endpoints.LogoutEndpoint;
import org.keycloak.protocol.oidc.endpoints.ThirdPartyCookiesIframeEndpoint;
import org.keycloak.protocol.oidc.endpoints.TokenEndpoint;
import org.keycloak.protocol.oidc.endpoints.TokenRevocationEndpoint;
import org.keycloak.protocol.oidc.endpoints.UserInfoEndpoint;
import org.keycloak.protocol.oidc.ext.OIDCExtProvider;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.CacheControlUtil;

public class OIDCLoginProtocolService {
    private final RealmModel realm;
    private final TokenManager tokenManager;
    private final EventBuilder event;
    private final OIDCProviderConfig providerConfig;
    private final KeycloakSession session;
    private final HttpHeaders headers;
    private final HttpRequest request;
    private final ClientConnection clientConnection;

    public OIDCLoginProtocolService(KeycloakSession session, EventBuilder event, OIDCProviderConfig providerConfig) {
        this.session = session;
        this.clientConnection = session.getContext().getConnection();
        this.realm = session.getContext().getRealm();
        this.tokenManager = new TokenManager();
        this.event = event;
        this.providerConfig = providerConfig;
        this.request = session.getContext().getHttpRequest();
        this.headers = session.getContext().getRequestHeaders();
    }

    public static UriBuilder tokenServiceBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
    }

    public static UriBuilder tokenServiceBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path("{realm}/protocol/openid-connect");
    }

    public static UriBuilder authUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OIDCLoginProtocolService.authUrl(baseUriBuilder);
    }

    public static UriBuilder authUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "auth");
    }

    public static UriBuilder registrationsUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "registrations");
    }

    public static UriBuilder tokenUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "token");
    }

    public static UriBuilder certsUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "certs");
    }

    public static UriBuilder userInfoUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "issueUserInfo");
    }

    public static UriBuilder tokenIntrospectionUrl(UriBuilder baseUriBuilder) {
        return OIDCLoginProtocolService.tokenUrl(baseUriBuilder).path(TokenEndpoint.class, "introspect");
    }

    public static UriBuilder logoutUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OIDCLoginProtocolService.logoutUrl(baseUriBuilder);
    }

    public static UriBuilder logoutUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "logout");
    }

    public static UriBuilder tokenRevocationUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "revoke");
    }

    @Path(value="auth")
    public Object auth() {
        return new AuthorizationEndpoint(this.session, this.event);
    }

    @Path(value="registrations")
    public Object registrations() {
        AuthorizationEndpoint endpoint = new AuthorizationEndpoint(this.session, this.event);
        return endpoint.register();
    }

    @Path(value="forgot-credentials")
    public Object forgotCredentialsPage() {
        AuthorizationEndpoint endpoint = new AuthorizationEndpoint(this.session, this.event);
        return endpoint.forgotCredentials();
    }

    @Path(value="token")
    public Object token() {
        return new TokenEndpoint(this.session, this.tokenManager, this.event);
    }

    @Path(value="login-status-iframe.html")
    public Object getLoginStatusIframe() {
        return new LoginStatusIframeEndpoint(this.session);
    }

    @Path(value="3p-cookies")
    public Object thirdPartyCookiesCheck() {
        return new ThirdPartyCookiesIframeEndpoint(this.session);
    }

    @OPTIONS
    @Path(value="certs")
    @Produces(value={"application/json"})
    public Response getVersionPreflight() {
        return Cors.add(this.request, Response.ok()).allowedMethods("GET").preflight().auth().build();
    }

    @GET
    @Path(value="certs")
    @Produces(value={"application/json"})
    @NoCache
    public Response certs() {
        this.checkSsl();
        JWK[] jwks = (JWK[])this.session.keys().getKeysStream(this.realm).filter(k -> k.getStatus().isEnabled() && k.getPublicKey() != null).map(k -> {
            JWKBuilder b = JWKBuilder.create().kid(k.getKid()).algorithm(k.getAlgorithmOrDefault());
            List certificates = Optional.ofNullable(k.getCertificateChain()).filter(certs -> !certs.isEmpty()).orElseGet(() -> Collections.singletonList(k.getCertificate()));
            if (k.getType().equals("RSA")) {
                return b.rsa(k.getPublicKey(), certificates, k.getUse());
            }
            if (k.getType().equals("EC")) {
                return b.ec(k.getPublicKey());
            }
            return null;
        }).filter(Objects::nonNull).toArray(JWK[]::new);
        JSONWebKeySet keySet = new JSONWebKeySet();
        keySet.setKeys(jwks);
        Response.ResponseBuilder responseBuilder = Response.ok((Object)keySet).cacheControl(CacheControlUtil.getDefaultCacheControl());
        return Cors.add(this.request, responseBuilder).allowedOrigins("*").auth().build();
    }

    @Path(value="userinfo")
    public Object issueUserInfo() {
        return new UserInfoEndpoint(this.session, this.tokenManager);
    }

    @Path(value="logout")
    public Object logout() {
        return new LogoutEndpoint(this.session, this.tokenManager, this.event, this.providerConfig);
    }

    @Path(value="revoke")
    public Object revoke() {
        return new TokenRevocationEndpoint(this.session, this.event);
    }

    @Path(value="oauth/oob")
    @GET
    public Response installedAppUrnCallback(@QueryParam(value="code") String code, @QueryParam(value="error") String error, @QueryParam(value="error_description") String errorDescription) {
        LoginFormsProvider forms = (LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class);
        if (code != null) {
            return forms.setClientSessionCode(code).createCode();
        }
        return forms.setError(error, new Object[0]).createCode();
    }

    @Path(value="ext/{extension}")
    public Object resolveExtension(@PathParam(value="extension") String extension) {
        OIDCExtProvider provider = (OIDCExtProvider)this.session.getProvider(OIDCExtProvider.class, extension);
        if (provider != null) {
            provider.setEvent(this.event);
            return provider;
        }
        throw new NotFoundException();
    }

    private void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            Cors cors = Cors.add(this.request).auth().allowedMethods(this.request.getHttpMethod()).auth().exposedHeaders("Access-Control-Allow-Methods");
            throw new CorsErrorResponseException(cors.allowAllOrigins(), "invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }
}

