/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.jose.jws.crypto.HashUtils;
import org.keycloak.models.UserModel;

public class RecoveryAuthnCodesUtils {
    private static final Logger logger = Logger.getLogger(RecoveryAuthnCodesUtils.class);
    public static final int QUANTITY_OF_CODES_TO_GENERATE = 12;
    private static final int CODE_LENGTH = 12;
    public static final char[] UPPERNUM = "ABCDEFGHIJKLMNPQRSTUVWXYZ123456789".toCharArray();
    private static final SecretGenerator SECRET_GENERATOR = SecretGenerator.getInstance();
    public static final String NOM_ALGORITHM_TO_HASH = "SHA-512";
    public static final String RECOVERY_AUTHN_CODES_INPUT_DEFAULT_ERROR_MESSAGE = "recovery-codes-error-invalid";
    public static final String FIELD_RECOVERY_CODE_IN_BROWSER_FLOW = "recoveryCodeInput";

    public static byte[] hashRawCode(String rawGeneratedCode) {
        Objects.requireNonNull(rawGeneratedCode, "rawGeneratedCode cannot be null");
        return HashUtils.hash((String)NOM_ALGORITHM_TO_HASH, (byte[])rawGeneratedCode.getBytes(StandardCharsets.UTF_8));
    }

    public static boolean verifyRecoveryCodeInput(String rawInputRecoveryCode, String hashedSavedRecoveryCode) {
        byte[] hashedInputBackupCode = RecoveryAuthnCodesUtils.hashRawCode(rawInputRecoveryCode);
        try {
            byte[] savedCode = Base64.getDecoder().decode(hashedSavedRecoveryCode);
            return MessageDigest.isEqual(hashedInputBackupCode, savedCode);
        }
        catch (IllegalArgumentException iae) {
            logger.warnf("Error when decoding saved recovery code", (Object)iae);
            return false;
        }
    }

    public static List<String> generateRawCodes() {
        Supplier<String> code = () -> SECRET_GENERATOR.randomString(12, UPPERNUM);
        return Stream.generate(code).limit(12L).collect(Collectors.toList());
    }

    public static Optional<CredentialModel> getCredential(UserModel user) {
        return user.credentialManager().getFederatedCredentialsStream().filter(c -> "recovery-authn-codes".equals(c.getType())).findFirst().or(() -> user.credentialManager().getStoredCredentialsByTypeStream("recovery-authn-codes").findFirst());
    }
}

