/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.function.BiConsumer;
import org.keycloak.Token;
import org.keycloak.TokenCategory;
import org.keycloak.jose.JOSE;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.LogoutToken;

public interface TokenManager {
    public static final BiConsumer<JOSE, ClientModel> DEFAULT_VALIDATOR = (jwt, client) -> {
        String rawAlgorithm = jwt.getHeader().getRawAlgorithm();
        if (rawAlgorithm.equalsIgnoreCase(Algorithm.none.name())) {
            throw new RuntimeException("Algorithm none not supported");
        }
    };

    public String encode(Token var1);

    public <T extends Token> T decode(String var1, Class<T> var2);

    public String signatureAlgorithm(TokenCategory var1);

    default public <T> T decodeClientJWT(String token, ClientModel client, Class<T> clazz) {
        return this.decodeClientJWT(token, client, DEFAULT_VALIDATOR, clazz);
    }

    public <T> T decodeClientJWT(String var1, ClientModel var2, BiConsumer<JOSE, ClientModel> var3, Class<T> var4);

    public String encodeAndEncrypt(Token var1);

    public String cekManagementAlgorithm(TokenCategory var1);

    public String encryptAlgorithm(TokenCategory var1);

    public LogoutToken initLogoutToken(ClientModel var1, UserModel var2, AuthenticatedClientSessionModel var3);
}

