/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.component;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.common.util.MultivaluedHashMap;

public class ComponentModel {
    private String id;
    private String name;
    private String providerId;
    private String providerType;
    private String parentId;
    private String subType;
    private MultivaluedHashMap<String, String> config = new MultivaluedHashMap();
    private transient ConcurrentHashMap<String, Object> notes = new ConcurrentHashMap();

    public ComponentModel() {
    }

    public ComponentModel(ComponentModel copy) {
        this.id = copy.id;
        this.name = copy.name;
        this.providerId = copy.providerId;
        this.providerType = copy.providerType;
        this.parentId = copy.parentId;
        this.subType = copy.subType;
        this.config.addAll(copy.config);
    }

    @ProtoField(value=1)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ProtoField(value=2)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MultivaluedHashMap<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(MultivaluedHashMap<String, String> config) {
        this.config = config;
    }

    public boolean contains(String key) {
        return this.config.containsKey((Object)key);
    }

    public String get(String key) {
        return (String)this.config.getFirst((Object)key);
    }

    public String get(String key, String defaultValue) {
        String s = this.get(key);
        return s != null ? s : defaultValue;
    }

    public int get(String key, int defaultValue) {
        String s = this.get(key);
        return s != null ? Integer.valueOf(s) : defaultValue;
    }

    public long get(String key, long defaultValue) {
        String s = this.get(key);
        return s != null ? Long.valueOf(s) : defaultValue;
    }

    public boolean get(String key, boolean defaultValue) {
        String s = this.get(key);
        return s != null ? Boolean.valueOf(s) : defaultValue;
    }

    public void put(String key, String value) {
        this.config.putSingle((Object)key, (Object)value);
    }

    public void put(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    public void put(String key, long value) {
        this.put(key, Long.toString(value));
    }

    public void put(String key, boolean value) {
        this.put(key, Boolean.toString(value));
    }

    public boolean hasNote(String key) {
        return this.notes.containsKey(key);
    }

    public <T> T getNote(String key) {
        return (T)this.notes.get(key);
    }

    public void setNote(String key, Object object) {
        this.notes.put(key, object);
    }

    public void removeNote(String key) {
        this.notes.remove(key);
    }

    @ProtoField(value=3)
    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    @ProtoField(value=4)
    public String getProviderType() {
        return this.providerType;
    }

    public void setProviderType(String providerType) {
        this.providerType = providerType;
    }

    @ProtoField(value=5)
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @ProtoField(value=6)
    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    @ProtoField(value=7)
    public List<MultiMapEntry> getConfigProto() {
        return this.config.entrySet().stream().map(MultiMapEntry::new).collect(Collectors.toList());
    }

    public void setConfigProto(List<MultiMapEntry> configProto) {
        if (configProto != null) {
            configProto.forEach(multiMapEntry -> multiMapEntry.insert(this.config));
        }
    }

    @ProtoTypeId(value=65538)
    public static final class MultiMapEntry {
        private final String key;
        private final List<String> value;

        @ProtoFactory
        public MultiMapEntry(String key, List<String> value) {
            this.key = key;
            this.value = value;
        }

        public MultiMapEntry(Map.Entry<String, List<String>> entry) {
            this(entry.getKey(), entry.getValue());
        }

        @ProtoField(value=1)
        public String getKey() {
            return this.key;
        }

        @ProtoField(value=2)
        public List<String> getValue() {
            return this.value;
        }

        public void insert(MultivaluedHashMap<String, String> config) {
            config.put((Object)this.key, this.value);
        }
    }
}

