/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Map;
import org.keycloak.models.UserSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

public interface AuthenticatedClientSessionModel
extends CommonClientSessionModel {
    public static final String STARTED_AT_NOTE = "startedAt";
    public static final String USER_SESSION_STARTED_AT_NOTE = "userSessionStartedAt";
    public static final String USER_SESSION_REMEMBER_ME_NOTE = "userSessionRememberMe";

    public String getId();

    default public int getStarted() {
        String started = this.getNote(STARTED_AT_NOTE);
        return started == null ? 0 : Integer.parseInt(started);
    }

    default public int getUserSessionStarted() {
        String started = this.getNote(USER_SESSION_STARTED_AT_NOTE);
        return started == null ? this.getUserSession().getStarted() : Integer.parseInt(started);
    }

    default public boolean isUserSessionRememberMe() {
        return Boolean.parseBoolean(this.getNote(USER_SESSION_REMEMBER_ME_NOTE));
    }

    public int getTimestamp();

    public void setTimestamp(int var1);

    public void detachFromUserSession();

    public UserSessionModel getUserSession();

    public String getCurrentRefreshToken();

    public void setCurrentRefreshToken(String var1);

    public int getCurrentRefreshTokenUseCount();

    public void setCurrentRefreshTokenUseCount(int var1);

    public String getNote(String var1);

    public void setNote(String var1, String var2);

    public void removeNote(String var1);

    public Map<String, String> getNotes();
}

