/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ValidatorConfig {
    public static final ValidatorConfig EMPTY = new ValidatorConfig(Collections.emptyMap());
    private final Map<String, Object> config;

    public ValidatorConfig(Map<String, Object> config) {
        this.config = config;
    }

    public static ValidatorConfig configFromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY;
        }
        return new ValidatorConfig(map);
    }

    public Map<String, Object> asMap() {
        return this.config;
    }

    public boolean containsKey(String key) {
        return this.config.containsKey(key);
    }

    public int size() {
        return this.config.size();
    }

    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    public Object get(String key) {
        return this.config.get(key);
    }

    public Object getOrDefault(String key, Object defaultValue) {
        return this.config.getOrDefault(key, defaultValue);
    }

    public String getString(String key) {
        return this.getStringOrDefault(key, null);
    }

    public String getStringOrDefault(String key, String defaultValue) {
        Object value = this.config.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    public Integer getInt(String key) {
        return this.getIntOrDefault(key, null);
    }

    public Integer getIntOrDefault(String key, Integer defaultValue) {
        Object value = this.config.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return new Integer((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return defaultValue;
    }

    public Long getLong(String key) {
        return this.getLongOrDefault(key, null);
    }

    public Long getLongOrDefault(String key, Long defaultValue) {
        Object value = this.config.get(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return new Long((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return defaultValue;
    }

    public Double getDouble(String key) {
        return this.getDoubleOrDefault(key, null);
    }

    public Double getDoubleOrDefault(String key, Double defaultValue) {
        Object value = this.config.get(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return defaultValue;
    }

    public Boolean getBoolean(String key) {
        return this.getBooleanOrDefault(key, null);
    }

    public Boolean getBooleanOrDefault(String key, Boolean defaultValue) {
        Object value = this.config.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    public Set<String> getStringSet(String key) {
        return this.getStringSetOrDefault(key, null);
    }

    public Set<String> getStringSetOrDefault(String key, Set<String> defaultValue) {
        Object value = this.config.get(key);
        if (value instanceof Set) {
            return (Set)value;
        }
        return defaultValue;
    }

    public List<String> getStringListOrDefault(String key) {
        return this.getStringListOrDefault(key, null);
    }

    public List<String> getStringListOrDefault(String key, List<String> defaultValue) {
        Object value = this.config.get(key);
        if (value instanceof List) {
            return (List)value;
        }
        return defaultValue;
    }

    public Pattern getPattern(String key) {
        return this.getPatternOrDefault(key, null);
    }

    public Pattern getPatternOrDefault(String key, Pattern defaultValue) {
        Object value = this.config.get(key);
        if (value instanceof Pattern) {
            return (Pattern)value;
        }
        if (value instanceof String) {
            return Pattern.compile((String)value);
        }
        return defaultValue;
    }

    public static ValidatorConfigBuilder builder() {
        return new ValidatorConfigBuilder();
    }

    public String toString() {
        return "ValidatorConfig{config=" + this.config + "}";
    }

    public static class ValidatorConfigBuilder {
        private Map<String, Object> config = new HashMap<String, Object>();

        public ValidatorConfig build() {
            return ValidatorConfig.configFromMap(this.config);
        }

        public ValidatorConfigBuilder config(String name, Object value) {
            this.config.put(name, value);
            return this;
        }

        public ValidatorConfigBuilder config(Map<String, Object> values) {
            if (values != null) {
                this.config.putAll(values);
            }
            return this;
        }

        public ValidatorConfigBuilder config(ValidatorConfig values) {
            if (values != null && values.config != null) {
                this.config.putAll(values.config);
            }
            return this;
        }
    }
}

