/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import org.keycloak.credential.CredentialMetadata;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.Provider;

public interface CredentialProvider<T extends CredentialModel>
extends Provider {
    @Override
    default public void close() {
    }

    public String getType();

    public CredentialModel createCredential(RealmModel var1, UserModel var2, T var3);

    public boolean deleteCredential(RealmModel var1, UserModel var2, String var3);

    public T getCredentialFromModel(CredentialModel var1);

    default public T getDefaultCredential(KeycloakSession session, RealmModel realm, UserModel user) {
        CredentialModel model = user.credentialManager().getStoredCredentialsByTypeStream(this.getType()).findFirst().orElse(null);
        return model != null ? (T)this.getCredentialFromModel(model) : null;
    }

    public CredentialTypeMetadata getCredentialTypeMetadata(CredentialTypeMetadataContext var1);

    default public CredentialMetadata getCredentialMetadata(T credentialModel, CredentialTypeMetadata credentialTypeMetadata) {
        CredentialMetadata credentialMetadata = new CredentialMetadata();
        credentialMetadata.setCredentialModel((CredentialModel)credentialModel);
        return credentialMetadata;
    }
}

