/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.credential;

import java.io.IOException;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.credential.dto.OTPCredentialData;
import org.keycloak.models.credential.dto.OTPSecretData;
import org.keycloak.util.JsonSerialization;

public class OTPCredentialModel
extends CredentialModel {
    public static final String TYPE = "otp";
    public static final String TOTP = "totp";
    public static final String HOTP = "hotp";
    private final OTPCredentialData credentialData;
    private final OTPSecretData secretData;

    private OTPCredentialModel(String secretValue, String subType, int digits, int counter, int period, String algorithm) {
        this.credentialData = new OTPCredentialData(subType, digits, counter, period, algorithm);
        this.secretData = new OTPSecretData(secretValue);
    }

    private OTPCredentialModel(OTPCredentialData credentialData, OTPSecretData secretData) {
        this.credentialData = credentialData;
        this.secretData = secretData;
    }

    public static OTPCredentialModel createTOTP(String secretValue, int digits, int period, String algorithm) {
        OTPCredentialModel credentialModel = new OTPCredentialModel(secretValue, TOTP, digits, 0, period, algorithm);
        credentialModel.fillCredentialModelFields();
        return credentialModel;
    }

    public static OTPCredentialModel createHOTP(String secretValue, int digits, int counter, String algorithm) {
        OTPCredentialModel credentialModel = new OTPCredentialModel(secretValue, HOTP, digits, counter, 0, algorithm);
        credentialModel.fillCredentialModelFields();
        return credentialModel;
    }

    public static OTPCredentialModel createFromPolicy(RealmModel realm, String secretValue) {
        return OTPCredentialModel.createFromPolicy(realm, secretValue, "");
    }

    public static OTPCredentialModel createFromPolicy(RealmModel realm, String secretValue, String userLabel) {
        OTPPolicy policy = realm.getOTPPolicy();
        OTPCredentialModel credentialModel = new OTPCredentialModel(secretValue, policy.getType(), policy.getDigits(), policy.getInitialCounter(), policy.getPeriod(), policy.getAlgorithm());
        credentialModel.fillCredentialModelFields();
        credentialModel.setUserLabel(userLabel);
        return credentialModel;
    }

    public static OTPCredentialModel createFromCredentialModel(CredentialModel credentialModel) {
        try {
            OTPCredentialData credentialData = (OTPCredentialData)JsonSerialization.readValue((String)credentialModel.getCredentialData(), OTPCredentialData.class);
            OTPSecretData secretData = (OTPSecretData)JsonSerialization.readValue((String)credentialModel.getSecretData(), OTPSecretData.class);
            OTPCredentialModel otpCredentialModel = new OTPCredentialModel(credentialData, secretData);
            otpCredentialModel.setUserLabel(credentialModel.getUserLabel());
            otpCredentialModel.setCreatedDate(credentialModel.getCreatedDate());
            otpCredentialModel.setType(TYPE);
            otpCredentialModel.setId(credentialModel.getId());
            otpCredentialModel.setSecretData(credentialModel.getSecretData());
            otpCredentialModel.setCredentialData(credentialModel.getCredentialData());
            return otpCredentialModel;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateCounter(int counter) {
        this.credentialData.setCounter(counter);
        try {
            this.setCredentialData(JsonSerialization.writeValueAsString((Object)this.credentialData));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public OTPCredentialData getOTPCredentialData() {
        return this.credentialData;
    }

    public OTPSecretData getOTPSecretData() {
        return this.secretData;
    }

    private void fillCredentialModelFields() {
        try {
            this.setCredentialData(JsonSerialization.writeValueAsString((Object)this.credentialData));
            this.setSecretData(JsonSerialization.writeValueAsString((Object)this.secretData));
            this.setType(TYPE);
            this.setCreatedDate(Time.currentTimeMillis());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

