/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.SearchableModelField;

public interface RoleModel {
    public String getName();

    public String getDescription();

    public void setDescription(String var1);

    public String getId();

    public void setName(String var1);

    public boolean isComposite();

    public void addCompositeRole(RoleModel var1);

    public void removeCompositeRole(RoleModel var1);

    default public Stream<RoleModel> getCompositesStream() {
        return this.getCompositesStream(null, null, null);
    }

    public Stream<RoleModel> getCompositesStream(String var1, Integer var2, Integer var3);

    public boolean isClientRole();

    public String getContainerId();

    public RoleContainerModel getContainer();

    public boolean hasRole(RoleModel var1);

    public void setSingleAttribute(String var1, String var2);

    public void setAttribute(String var1, List<String> var2);

    public void removeAttribute(String var1);

    default public String getFirstAttribute(String name) {
        return this.getAttributeStream(name).findFirst().orElse(null);
    }

    public Stream<String> getAttributeStream(String var1);

    public Map<String, List<String>> getAttributes();

    public static interface RoleNameChangeEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public String getNewName();

        public String getPreviousName();

        public String getClientId();

        public KeycloakSession getKeycloakSession();
    }

    public static class SearchableFields {
        public static final SearchableModelField<RoleModel> ID = new SearchableModelField("id", String.class);
        public static final SearchableModelField<RoleModel> REALM_ID = new SearchableModelField("realmId", String.class);
        public static final SearchableModelField<RoleModel> CLIENT_ID = new SearchableModelField("clientId", String.class);
        public static final SearchableModelField<RoleModel> NAME = new SearchableModelField("name", String.class);
        public static final SearchableModelField<RoleModel> DESCRIPTION = new SearchableModelField("description", String.class);
        @Deprecated
        public static final SearchableModelField<RoleModel> IS_CLIENT_ROLE = new SearchableModelField("isClientRole", Boolean.class);
        public static final SearchableModelField<RoleModel> COMPOSITE_ROLE = new SearchableModelField("compositeRoles", Boolean.class);
    }
}

