/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.Provider;

public interface UserCredentialStore
extends Provider {
    public void updateCredential(RealmModel var1, UserModel var2, CredentialModel var3);

    public CredentialModel createCredential(RealmModel var1, UserModel var2, CredentialModel var3);

    public boolean removeStoredCredential(RealmModel var1, UserModel var2, String var3);

    public CredentialModel getStoredCredentialById(RealmModel var1, UserModel var2, String var3);

    @Deprecated
    public List<CredentialModel> getStoredCredentials(RealmModel var1, UserModel var2);

    default public Stream<CredentialModel> getStoredCredentialsStream(RealmModel realm, UserModel user) {
        List<CredentialModel> result = this.getStoredCredentials(realm, user);
        return result != null ? result.stream() : Stream.empty();
    }

    @Deprecated
    public List<CredentialModel> getStoredCredentialsByType(RealmModel var1, UserModel var2, String var3);

    default public Stream<CredentialModel> getStoredCredentialsByTypeStream(RealmModel realm, UserModel user, String type) {
        List<CredentialModel> result = this.getStoredCredentialsByType(realm, user, type);
        return result != null ? result.stream() : Stream.empty();
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel var1, UserModel var2, String var3, String var4);

    public boolean moveCredentialTo(RealmModel var1, UserModel var2, String var3, String var4);

    public static interface Streams
    extends UserCredentialStore {
        @Override
        default public List<CredentialModel> getStoredCredentials(RealmModel realm, UserModel user) {
            return this.getStoredCredentialsStream(realm, user).collect(Collectors.toList());
        }

        @Override
        public Stream<CredentialModel> getStoredCredentialsStream(RealmModel var1, UserModel var2);

        @Override
        default public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, UserModel user, String type) {
            return this.getStoredCredentialsByTypeStream(realm, user, type).collect(Collectors.toList());
        }

        @Override
        public Stream<CredentialModel> getStoredCredentialsByTypeStream(RealmModel var1, UserModel var2, String var3);
    }
}

