/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.workflows;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.representations.workflows.AbstractWorkflowComponentRepresentation;
import org.keycloak.representations.workflows.WorkflowConditionRepresentation;
import org.keycloak.representations.workflows.WorkflowSetRepresentation;
import org.keycloak.representations.workflows.WorkflowStateRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;

@JsonPropertyOrder(value={"id", "name", "uses", "enabled", "on", "reset-on", "recurring", "if", "steps", "state"})
@JsonIgnoreProperties(value={"with"})
public final class WorkflowRepresentation
extends AbstractWorkflowComponentRepresentation {
    private List<WorkflowStepRepresentation> steps;
    @JsonProperty(value="if")
    private List<WorkflowConditionRepresentation> conditions;
    private WorkflowStateRepresentation state;

    public static Builder create() {
        return new Builder().of("event-based-workflow");
    }

    public WorkflowRepresentation() {
        super(null, null, null);
    }

    public WorkflowRepresentation(String id, String workflow, MultivaluedHashMap<String, String> config, List<WorkflowConditionRepresentation> conditions, List<WorkflowStepRepresentation> steps) {
        super(id, workflow, config);
        this.conditions = conditions;
        this.steps = steps;
    }

    public <T> T getOn() {
        return this.getConfigValuesOrSingle("on");
    }

    public void setOn(String ... events) {
        this.setConfigValue("on", Arrays.asList(events));
    }

    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    public void setOn(List<String> events) {
        this.setConfigValue("on", events);
    }

    @JsonIgnore
    public List<String> getOnValues() {
        return Optional.ofNullable(this.getConfigValues("on")).orElse(Collections.emptyList());
    }

    @JsonProperty(value="reset-on")
    public <T> T getOnEventReset() {
        return this.getConfigValuesOrSingle("reset-on");
    }

    @JsonIgnore
    public List<String> getOnEventsReset() {
        return Optional.ofNullable(this.getConfigValues("reset-on")).orElse(Collections.emptyList());
    }

    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    public void setOnEventReset(List<String> names) {
        this.setConfigValue("reset-on", names);
    }

    @JsonIgnore
    public void setOnEventReset(String ... names) {
        this.setOnEventReset(Arrays.asList(names));
    }

    public String getName() {
        return this.getConfigValue("name", String.class);
    }

    public void setName(String name) {
        this.setConfigValue("name", name);
    }

    public Boolean getRecurring() {
        return this.getConfigValue("recurring", Boolean.class);
    }

    public void setRecurring(Boolean recurring) {
        this.setConfigValue("recurring", recurring);
    }

    public Boolean getEnabled() {
        return this.getConfigValue("enabled", Boolean.class);
    }

    public void setEnabled(Boolean enabled) {
        this.setConfigValue("enabled", enabled);
    }

    public void setConditions(List<WorkflowConditionRepresentation> conditions) {
        this.conditions = conditions;
    }

    public List<WorkflowConditionRepresentation> getConditions() {
        return this.conditions;
    }

    public void setSteps(List<WorkflowStepRepresentation> steps) {
        this.steps = steps;
    }

    public List<WorkflowStepRepresentation> getSteps() {
        return this.steps;
    }

    public WorkflowStateRepresentation getState() {
        if (this.state == null) {
            this.state = new WorkflowStateRepresentation(this);
        }
        if (this.state.getErrors().isEmpty()) {
            return null;
        }
        return this.state;
    }

    public void setState(WorkflowStateRepresentation state) {
        this.state = state;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WorkflowRepresentation)) {
            return false;
        }
        WorkflowRepresentation that = (WorkflowRepresentation)obj;
        return Objects.equals(this.getUses(), that.getUses()) && Objects.equals(this.getConfig(), that.getConfig()) && Objects.equals(this.getConditions(), that.getConditions()) && Objects.equals(this.getSteps(), that.getSteps());
    }

    public static class Builder {
        private final Map<WorkflowRepresentation, List<WorkflowStepRepresentation>> steps = new HashMap<WorkflowRepresentation, List<WorkflowStepRepresentation>>();
        private List<Builder> builders = new ArrayList<Builder>();
        private WorkflowRepresentation representation;

        private Builder() {
        }

        private Builder(WorkflowRepresentation representation, List<Builder> builders) {
            this.representation = representation;
            this.builders = builders;
        }

        public Builder of(String providerId) {
            WorkflowRepresentation representation = new WorkflowRepresentation();
            representation.setUses(providerId);
            Builder builder = new Builder(representation, this.builders);
            this.builders.add(builder);
            return builder;
        }

        public Builder onEvent(String operation) {
            this.representation.addConfigValue("on", operation);
            return this;
        }

        public Builder onConditions(WorkflowConditionRepresentation ... condition) {
            this.representation.setConditions(Arrays.asList(condition));
            return this;
        }

        public Builder withSteps(WorkflowStepRepresentation ... steps) {
            this.steps.computeIfAbsent(this.representation, k -> new ArrayList()).addAll(Arrays.asList(steps));
            return this;
        }

        public Builder withConfig(String key, String value) {
            this.representation.addConfigValue(key, value);
            return this;
        }

        public Builder withConfig(String key, List<String> values) {
            this.representation.setConfigValue(key, values);
            return this;
        }

        public Builder name(String name) {
            this.representation.setName(name);
            return this;
        }

        public Builder recurring() {
            this.representation.setRecurring(true);
            return this;
        }

        public WorkflowSetRepresentation build() {
            ArrayList<WorkflowRepresentation> workflows = new ArrayList<WorkflowRepresentation>();
            for (Builder builder : this.builders) {
                if (builder.steps.isEmpty()) continue;
                for (Map.Entry<WorkflowRepresentation, List<WorkflowStepRepresentation>> entry : builder.steps.entrySet()) {
                    WorkflowRepresentation workflow = entry.getKey();
                    workflow.setSteps(entry.getValue());
                    workflows.add(workflow);
                }
            }
            return new WorkflowSetRepresentation(workflows);
        }
    }
}

