/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;

public class DelegatingSerializationFilter {
    private static final Logger LOG = Logger.getLogger((String)DelegatingSerializationFilter.class.getName());
    private static final SerializationFilterAdapter serializationFilterAdapter = DelegatingSerializationFilter.isJava6To8() ? DelegatingSerializationFilter.createOnJava6To8Adapter() : DelegatingSerializationFilter.createOnJavaAfter8Adapter();

    private static boolean isJava6To8() {
        List<String> olderVersions = Arrays.asList("1.6", "1.7", "1.8");
        return olderVersions.contains(System.getProperty("java.specification.version"));
    }

    private DelegatingSerializationFilter() {
    }

    public static FilterPatternBuilder builder() {
        return new FilterPatternBuilder();
    }

    private void setFilter(ObjectInputStream ois, String filterPattern) {
        LOG.debug((Object)("Using: " + serializationFilterAdapter.getClass().getSimpleName()));
        if (serializationFilterAdapter.getObjectInputFilter(ois) == null) {
            serializationFilterAdapter.setObjectInputFilter(ois, filterPattern);
        }
    }

    private static SerializationFilterAdapter createOnJava6To8Adapter() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> objectInputFilterClass = cl.loadClass("sun.misc.ObjectInputFilter");
            Class<?> objectInputFilterConfigClass = cl.loadClass("sun.misc.ObjectInputFilter$Config");
            Method getObjectInputFilter = objectInputFilterConfigClass.getDeclaredMethod("getObjectInputFilter", ObjectInputStream.class);
            Method setObjectInputFilter = objectInputFilterConfigClass.getDeclaredMethod("setObjectInputFilter", ObjectInputStream.class, objectInputFilterClass);
            Method createFilter = objectInputFilterConfigClass.getDeclaredMethod("createFilter", String.class);
            LOG.info((Object)"Using OnJava6To8 serialization filter adapter");
            return new OnJava6To8(getObjectInputFilter, setObjectInputFilter, createFilter);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LOG.warn((Object)"Could not configure SerializationFilterAdapter. For better security, it is highly recommended to upgrade to newer JDK version update!");
            LOG.warn((Object)"For the Java 7, the recommended update is at least 131 (1.7.0_131 or newer). For the Java 8, the recommended update is at least 121 (1.8.0_121 or newer).");
            LOG.warn((Object)"Error details", (Throwable)e);
            return new EmptyFilterAdapter();
        }
    }

    private static SerializationFilterAdapter createOnJavaAfter8Adapter() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> objectInputFilterClass = cl.loadClass("java.io.ObjectInputFilter");
            Class<?> objectInputFilterConfigClass = cl.loadClass("java.io.ObjectInputFilter$Config");
            Class<?> objectInputStreamClass = cl.loadClass("java.io.ObjectInputStream");
            Method getObjectInputFilter = objectInputStreamClass.getDeclaredMethod("getObjectInputFilter", new Class[0]);
            Method setObjectInputFilter = objectInputStreamClass.getDeclaredMethod("setObjectInputFilter", objectInputFilterClass);
            Method createFilter = objectInputFilterConfigClass.getDeclaredMethod("createFilter", String.class);
            LOG.info((Object)"Using OnJavaAfter8 serialization filter adapter");
            return new OnJavaAfter8(getObjectInputFilter, setObjectInputFilter, createFilter);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LOG.warn((Object)"Could not configure SerializationFilterAdapter. For better security, it is highly recommended to upgrade to newer JDK version update!");
            LOG.warn((Object)"Error details", (Throwable)e);
            return new EmptyFilterAdapter();
        }
    }

    public static class FilterPatternBuilder {
        private Set<Class> classes = new HashSet<Class>();
        private Set<String> patterns = new HashSet<String>();

        public FilterPatternBuilder() {
            this.addAllowedPattern("java.util.*");
        }

        public FilterPatternBuilder addAllowedPattern(String pattern) {
            this.patterns.add(pattern);
            return this;
        }

        public FilterPatternBuilder addAllowedClass(Class javaClass) {
            this.classes.add(javaClass);
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Class javaClass : this.classes) {
                builder.append(javaClass.getName()).append(";");
            }
            for (String pattern : this.patterns) {
                builder.append(pattern).append(";");
            }
            builder.append("!*");
            return builder.toString();
        }

        public void setFilter(ObjectInputStream ois) {
            DelegatingSerializationFilter filter = new DelegatingSerializationFilter();
            String filterPattern = this.toString();
            filter.setFilter(ois, filterPattern);
        }
    }

    static class OnJavaAfter8
    implements SerializationFilterAdapter {
        private final Method getObjectInputFilterMethod;
        private final Method setObjectInputFilterMethod;
        private final Method createFilterMethod;

        private OnJavaAfter8(Method getObjectInputFilterMethod, Method setObjectInputFilterMethod, Method createFilterMethod) {
            this.getObjectInputFilterMethod = getObjectInputFilterMethod;
            this.setObjectInputFilterMethod = setObjectInputFilterMethod;
            this.createFilterMethod = createFilterMethod;
        }

        @Override
        public Object getObjectInputFilter(ObjectInputStream ois) {
            try {
                return this.getObjectInputFilterMethod.invoke((Object)ois, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.warn((Object)("Could not read ObjectFilter from ObjectInputStream: " + e.getMessage()));
                return null;
            }
        }

        @Override
        public void setObjectInputFilter(ObjectInputStream ois, String filterPattern) {
            try {
                Object objectFilter = this.createFilterMethod.invoke((Object)ois, filterPattern);
                this.setObjectInputFilterMethod.invoke((Object)ois, objectFilter);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.warn((Object)("Could not set ObjectFilter: " + e.getMessage()));
            }
        }
    }

    static class EmptyFilterAdapter
    implements SerializationFilterAdapter {
        EmptyFilterAdapter() {
        }

        @Override
        public Object getObjectInputFilter(ObjectInputStream ois) {
            return null;
        }

        @Override
        public void setObjectInputFilter(ObjectInputStream ois, String filterPattern) {
        }
    }

    static class OnJava6To8
    implements SerializationFilterAdapter {
        private final Method getObjectInputFilterMethod;
        private final Method setObjectInputFilterMethod;
        private final Method createFilterMethod;

        private OnJava6To8(Method getObjectInputFilterMethod, Method setObjectInputFilterMethod, Method createFilterMethod) {
            this.getObjectInputFilterMethod = getObjectInputFilterMethod;
            this.setObjectInputFilterMethod = setObjectInputFilterMethod;
            this.createFilterMethod = createFilterMethod;
        }

        @Override
        public Object getObjectInputFilter(ObjectInputStream ois) {
            try {
                return this.getObjectInputFilterMethod.invoke(null, ois);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.warn((Object)("Could not read ObjectFilter from ObjectInputStream: " + e.getMessage()));
                return null;
            }
        }

        @Override
        public void setObjectInputFilter(ObjectInputStream ois, String filterPattern) {
            try {
                Object objectFilter = this.createFilterMethod.invoke(null, filterPattern);
                this.setObjectInputFilterMethod.invoke(null, ois, objectFilter);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.warn((Object)("Could not set ObjectFilter: " + e.getMessage()));
            }
        }
    }

    static interface SerializationFilterAdapter {
        public Object getObjectInputFilter(ObjectInputStream var1);

        public void setObjectInputFilter(ObjectInputStream var1, String var2);
    }
}

