/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.StringUtil;

public class ShortConverter
implements TypeConverter<Short> {
    @Override
    public Short convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Short.class) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Short.valueOf((short)1) : Short.valueOf((short)0);
        }
        try {
            String stringValue = value.toString().trim();
            if (StringUtil.startsWithChar((String)stringValue, (char)'+')) {
                stringValue = stringValue.substring(1);
            }
            return Short.valueOf(stringValue);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

