/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.shadow.org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.util.Collection;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.JGitText;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.util.References;

public final class StringUtils {
    private static final char[] LC = new char[91];

    static {
        int c = 0;
        while (c < LC.length) {
            StringUtils.LC[c] = c;
            c = (char)(c + 1);
        }
        c = 65;
        while (c <= 90) {
            StringUtils.LC[c] = (char)(97 + (c - 65));
            c = (char)(c + 1);
        }
    }

    public static char toLowerCase(char c) {
        return c <= 'Z' ? LC[c] : c;
    }

    public static String toLowerCase(String in) {
        StringBuilder r = new StringBuilder(in.length());
        int i2 = 0;
        while (i2 < in.length()) {
            r.append(StringUtils.toLowerCase(in.charAt(i2)));
            ++i2;
        }
        return r.toString();
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        if (References.isSameObject(a, b)) {
            return true;
        }
        if (a.length() != b.length()) {
            return false;
        }
        int i2 = 0;
        while (i2 < a.length()) {
            if (StringUtils.toLowerCase(a.charAt(i2)) != StringUtils.toLowerCase(b.charAt(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static int compareIgnoreCase(String a, String b) {
        int i2 = 0;
        while (i2 < a.length() && i2 < b.length()) {
            int d = StringUtils.toLowerCase(a.charAt(i2)) - StringUtils.toLowerCase(b.charAt(i2));
            if (d != 0) {
                return d;
            }
            ++i2;
        }
        return a.length() - b.length();
    }

    public static int compareWithCase(String a, String b) {
        int i2 = 0;
        while (i2 < a.length() && i2 < b.length()) {
            int d = a.charAt(i2) - b.charAt(i2);
            if (d != 0) {
                return d;
            }
            ++i2;
        }
        return a.length() - b.length();
    }

    public static boolean toBoolean(String stringValue) {
        if (stringValue == null) {
            throw new NullPointerException(JGitText.get().expectedBooleanStringValue);
        }
        Boolean bool = StringUtils.toBooleanOrNull(stringValue);
        if (bool == null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().notABoolean, stringValue));
        }
        return bool;
    }

    public static Boolean toBooleanOrNull(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        if (StringUtils.equalsIgnoreCase("yes", stringValue) || StringUtils.equalsIgnoreCase("true", stringValue) || StringUtils.equalsIgnoreCase("1", stringValue) || StringUtils.equalsIgnoreCase("on", stringValue)) {
            return Boolean.TRUE;
        }
        if (StringUtils.equalsIgnoreCase("no", stringValue) || StringUtils.equalsIgnoreCase("false", stringValue) || StringUtils.equalsIgnoreCase("0", stringValue) || StringUtils.equalsIgnoreCase("off", stringValue)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static String join(Collection<String> parts, String separator) {
        return StringUtils.join(parts, separator, separator);
    }

    public static String join(Collection<String> parts, String separator, String lastSeparator) {
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        int lastIndex = parts.size() - 1;
        for (String part : parts) {
            sb.append(part);
            if (i2 == lastIndex - 1) {
                sb.append(lastSeparator);
            } else if (i2 != lastIndex) {
                sb.append(separator);
            }
            ++i2;
        }
        return sb.toString();
    }

    private StringUtils() {
    }

    public static boolean isEmptyOrNull(String stringValue) {
        return stringValue == null || stringValue.length() == 0;
    }

    public static String replaceLineBreaksWithSpace(String in) {
        char[] buf = new char[in.length()];
        int o = 0;
        int i2 = 0;
        while (i2 < buf.length) {
            char ch = in.charAt(i2);
            if (ch == '\r') {
                if (i2 + 1 < buf.length && in.charAt(i2 + 1) == '\n') {
                    buf[o++] = 32;
                    ++i2;
                } else {
                    buf[o++] = 32;
                }
            } else {
                buf[o++] = ch == '\n' ? 32 : ch;
            }
            ++i2;
        }
        return new String(buf, 0, o);
    }
}

